package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait SubscriptionProtocolType {
  def unwrap: software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType
}
object SubscriptionProtocolType {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType
  ): zio.aws.securitylake.model.SubscriptionProtocolType = value match {
    case software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.HTTP =>
      val r = HTTP
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.HTTPS =>
      val r = HTTPS
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.EMAIL =>
      val r = EMAIL
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.EMAIL_JSON =>
      val r = EMAIL_JSON
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.SMS =>
      val r = SMS
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.SQS =>
      val r = SQS
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.LAMBDA =>
      val r = LAMBDA
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.APP =>
      val r = APP
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.FIREHOSE =>
      val r = FIREHOSE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.SubscriptionProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType =
      software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP extends zio.aws.securitylake.model.SubscriptionProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType =
      software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.HTTP
  }
  case object HTTPS
      extends zio.aws.securitylake.model.SubscriptionProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType =
      software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.HTTPS
  }
  case object EMAIL
      extends zio.aws.securitylake.model.SubscriptionProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType =
      software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.EMAIL
  }
  case object EMAIL_JSON
      extends zio.aws.securitylake.model.SubscriptionProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType =
      software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.EMAIL_JSON
  }
  case object SMS extends zio.aws.securitylake.model.SubscriptionProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType =
      software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.SMS
  }
  case object SQS extends zio.aws.securitylake.model.SubscriptionProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType =
      software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.SQS
  }
  case object LAMBDA
      extends zio.aws.securitylake.model.SubscriptionProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType =
      software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.LAMBDA
  }
  case object APP extends zio.aws.securitylake.model.SubscriptionProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType =
      software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.APP
  }
  case object FIREHOSE
      extends zio.aws.securitylake.model.SubscriptionProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType =
      software.amazon.awssdk.services.securitylake.model.SubscriptionProtocolType.FIREHOSE
  }
}
