package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait SubscriptionStatus {
  def unwrap
      : software.amazon.awssdk.services.securitylake.model.SubscriptionStatus
}
object SubscriptionStatus {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.SubscriptionStatus
  ): zio.aws.securitylake.model.SubscriptionStatus = value match {
    case software.amazon.awssdk.services.securitylake.model.SubscriptionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriptionStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriptionStatus.DEACTIVATED =>
      val r = DEACTIVATED
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriptionStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriptionStatus.READY =>
      val r = READY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.SubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionStatus =
      software.amazon.awssdk.services.securitylake.model.SubscriptionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.securitylake.model.SubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionStatus =
      software.amazon.awssdk.services.securitylake.model.SubscriptionStatus.ACTIVE
  }
  case object DEACTIVATED
      extends zio.aws.securitylake.model.SubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionStatus =
      software.amazon.awssdk.services.securitylake.model.SubscriptionStatus.DEACTIVATED
  }
  case object PENDING extends zio.aws.securitylake.model.SubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionStatus =
      software.amazon.awssdk.services.securitylake.model.SubscriptionStatus.PENDING
  }
  case object READY extends zio.aws.securitylake.model.SubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriptionStatus =
      software.amazon.awssdk.services.securitylake.model.SubscriptionStatus.READY
  }
}
