package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateDatalakeRequest(
    configurations: Map[
      zio.aws.securitylake.model.Region,
      zio.aws.securitylake.model.LakeConfigurationRequest
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.UpdateDatalakeRequest = {
    import UpdateDatalakeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.UpdateDatalakeRequest
      .builder()
      .configurationsWithStrings(
        configurations
          .map({ case (key, value) =>
            key.unwrap.toString -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.UpdateDatalakeRequest.ReadOnly =
    zio.aws.securitylake.model.UpdateDatalakeRequest.wrap(buildAwsValue())
}
object UpdateDatalakeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.UpdateDatalakeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.UpdateDatalakeRequest =
      zio.aws.securitylake.model.UpdateDatalakeRequest(configurations.map({
        case (key, value) =>
          key -> value.asEditable
      }))
    def configurations: Map[
      zio.aws.securitylake.model.Region,
      zio.aws.securitylake.model.LakeConfigurationRequest.ReadOnly
    ]
    def getConfigurations: ZIO[Any, Nothing, Map[
      zio.aws.securitylake.model.Region,
      zio.aws.securitylake.model.LakeConfigurationRequest.ReadOnly
    ]] = ZIO.succeed(configurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateDatalakeRequest
  ) extends zio.aws.securitylake.model.UpdateDatalakeRequest.ReadOnly {
    override val configurations: Map[
      zio.aws.securitylake.model.Region,
      zio.aws.securitylake.model.LakeConfigurationRequest.ReadOnly
    ] = impl
      .configurations()
      .asScala
      .map({ case (key, value) =>
        zio.aws.securitylake.model.Region.wrap(
          key
        ) -> zio.aws.securitylake.model.LakeConfigurationRequest.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateDatalakeRequest
  ): zio.aws.securitylake.model.UpdateDatalakeRequest.ReadOnly = new Wrapper(
    impl
  )
}
