package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateStatus(
    lastUpdateFailure: Optional[zio.aws.securitylake.model.LastUpdateFailure] =
      Optional.Absent,
    lastUpdateRequestId: Optional[String] = Optional.Absent,
    lastUpdateStatus: Optional[zio.aws.securitylake.model.SettingsStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.UpdateStatus = {
    import UpdateStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.UpdateStatus
      .builder()
      .optionallyWith(lastUpdateFailure.map(value => value.buildAwsValue()))(
        _.lastUpdateFailure
      )
      .optionallyWith(
        lastUpdateRequestId.map(value => value: java.lang.String)
      )(_.lastUpdateRequestId)
      .optionallyWith(lastUpdateStatus.map(value => value.unwrap))(
        _.lastUpdateStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.UpdateStatus.ReadOnly =
    zio.aws.securitylake.model.UpdateStatus.wrap(buildAwsValue())
}
object UpdateStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.UpdateStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.UpdateStatus =
      zio.aws.securitylake.model.UpdateStatus(
        lastUpdateFailure.map(value => value.asEditable),
        lastUpdateRequestId.map(value => value),
        lastUpdateStatus.map(value => value)
      )
    def lastUpdateFailure
        : Optional[zio.aws.securitylake.model.LastUpdateFailure.ReadOnly]
    def lastUpdateRequestId: Optional[String]
    def lastUpdateStatus: Optional[zio.aws.securitylake.model.SettingsStatus]
    def getLastUpdateFailure: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.LastUpdateFailure.ReadOnly
    ] = AwsError.unwrapOptionField("lastUpdateFailure", lastUpdateFailure)
    def getLastUpdateRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastUpdateRequestId", lastUpdateRequestId)
    def getLastUpdateStatus
        : ZIO[Any, AwsError, zio.aws.securitylake.model.SettingsStatus] =
      AwsError.unwrapOptionField("lastUpdateStatus", lastUpdateStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateStatus
  ) extends zio.aws.securitylake.model.UpdateStatus.ReadOnly {
    override val lastUpdateFailure
        : Optional[zio.aws.securitylake.model.LastUpdateFailure.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateFailure())
        .map(value => zio.aws.securitylake.model.LastUpdateFailure.wrap(value))
    override val lastUpdateRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateRequestId())
      .map(value => value: String)
    override val lastUpdateStatus
        : Optional[zio.aws.securitylake.model.SettingsStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateStatus())
        .map(value => zio.aws.securitylake.model.SettingsStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateStatus
  ): zio.aws.securitylake.model.UpdateStatus.ReadOnly = new Wrapper(impl)
}
