package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  UUID,
  UpdateSubscriptionNotificationConfigurationRequestSubscriptionEndpointString,
  RoleArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSubscriptionNotificationConfigurationRequest(
    createSqs: Optional[Boolean] = Optional.Absent,
    httpsApiKeyName: Optional[String] = Optional.Absent,
    httpsApiKeyValue: Optional[String] = Optional.Absent,
    httpsMethod: Optional[zio.aws.securitylake.model.HttpsMethod] =
      Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    subscriptionEndpoint: Optional[
      UpdateSubscriptionNotificationConfigurationRequestSubscriptionEndpointString
    ] = Optional.Absent,
    subscriptionId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest = {
    import UpdateSubscriptionNotificationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest
      .builder()
      .optionallyWith(createSqs.map(value => value: java.lang.Boolean))(
        _.createSqs
      )
      .optionallyWith(httpsApiKeyName.map(value => value: java.lang.String))(
        _.httpsApiKeyName
      )
      .optionallyWith(httpsApiKeyValue.map(value => value: java.lang.String))(
        _.httpsApiKeyValue
      )
      .optionallyWith(httpsMethod.map(value => value.unwrap))(_.httpsMethod)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        subscriptionEndpoint.map(value =>
          UpdateSubscriptionNotificationConfigurationRequestSubscriptionEndpointString
            .unwrap(value): java.lang.String
        )
      )(_.subscriptionEndpoint)
      .subscriptionId(UUID.unwrap(subscriptionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest.ReadOnly =
    zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateSubscriptionNotificationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest =
      zio.aws.securitylake.model
        .UpdateSubscriptionNotificationConfigurationRequest(
          createSqs.map(value => value),
          httpsApiKeyName.map(value => value),
          httpsApiKeyValue.map(value => value),
          httpsMethod.map(value => value),
          roleArn.map(value => value),
          subscriptionEndpoint.map(value => value),
          subscriptionId
        )
    def createSqs: Optional[Boolean]
    def httpsApiKeyName: Optional[String]
    def httpsApiKeyValue: Optional[String]
    def httpsMethod: Optional[zio.aws.securitylake.model.HttpsMethod]
    def roleArn: Optional[RoleArn]
    def subscriptionEndpoint: Optional[
      UpdateSubscriptionNotificationConfigurationRequestSubscriptionEndpointString
    ]
    def subscriptionId: UUID
    def getCreateSqs: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("createSqs", createSqs)
    def getHttpsApiKeyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("httpsApiKeyName", httpsApiKeyName)
    def getHttpsApiKeyValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("httpsApiKeyValue", httpsApiKeyValue)
    def getHttpsMethod
        : ZIO[Any, AwsError, zio.aws.securitylake.model.HttpsMethod] =
      AwsError.unwrapOptionField("httpsMethod", httpsMethod)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getSubscriptionEndpoint: ZIO[
      Any,
      AwsError,
      UpdateSubscriptionNotificationConfigurationRequestSubscriptionEndpointString
    ] = AwsError.unwrapOptionField("subscriptionEndpoint", subscriptionEndpoint)
    def getSubscriptionId: ZIO[Any, Nothing, UUID] = ZIO.succeed(subscriptionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest
  ) extends zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest.ReadOnly {
    override val createSqs: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.createSqs())
      .map(value => value: Boolean)
    override val httpsApiKeyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.httpsApiKeyName())
      .map(value => value: String)
    override val httpsApiKeyValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.httpsApiKeyValue())
      .map(value => value: String)
    override val httpsMethod: Optional[zio.aws.securitylake.model.HttpsMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpsMethod())
        .map(value => zio.aws.securitylake.model.HttpsMethod.wrap(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.securitylake.model.primitives.RoleArn(value))
    override val subscriptionEndpoint: Optional[
      UpdateSubscriptionNotificationConfigurationRequestSubscriptionEndpointString
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.subscriptionEndpoint())
      .map(value =>
        zio.aws.securitylake.model.primitives
          .UpdateSubscriptionNotificationConfigurationRequestSubscriptionEndpointString(
            value
          )
      )
    override val subscriptionId: UUID =
      zio.aws.securitylake.model.primitives.UUID(impl.subscriptionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest
  ): zio.aws.securitylake.model.UpdateSubscriptionNotificationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
