package zio.aws.securitylake
import zio.aws.securitylake.model.GetDataLakeOrganizationConfigurationResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.securitylake.paginators.{
  ListSubscribersPublisher,
  ListDataLakeExceptionsPublisher,
  ListLogSourcesPublisher,
  GetDataLakeSourcesPublisher
}
import software.amazon.awssdk.services.securitylake.model.{
  DeleteDataLakeOrganizationConfigurationResponse,
  DeleteSubscriberNotificationRequest,
  SubscriberResource,
  DeleteDataLakeExceptionSubscriptionRequest,
  CreateSubscriberNotificationResponse,
  DeleteAwsLogSourceRequest,
  RegisterDataLakeDelegatedAdministratorResponse,
  CreateDataLakeOrganizationConfigurationRequest,
  CreateSubscriberRequest,
  ListDataLakeExceptionsResponse,
  DeregisterDataLakeDelegatedAdministratorRequest,
  DeleteDataLakeResponse,
  UpdateSubscriberNotificationResponse,
  DeleteSubscriberNotificationResponse,
  CreateSubscriberNotificationRequest,
  GetSubscriberResponse,
  CreateCustomLogSourceRequest,
  CreateDataLakeOrganizationConfigurationResponse,
  ListLogSourcesRequest,
  ListLogSourcesResponse,
  CreateCustomLogSourceResponse,
  CreateAwsLogSourceRequest,
  DeleteDataLakeExceptionSubscriptionResponse,
  ListTagsForResourceRequest,
  CreateDataLakeResponse,
  UpdateSubscriberResponse,
  DeleteSubscriberRequest,
  RegisterDataLakeDelegatedAdministratorRequest,
  UpdateDataLakeRequest,
  DataLakeSource,
  ListDataLakesRequest,
  GetDataLakeExceptionSubscriptionRequest,
  ListDataLakeExceptionsRequest,
  DeleteDataLakeOrganizationConfigurationRequest,
  DeleteCustomLogSourceResponse,
  DeleteDataLakeRequest,
  GetDataLakeOrganizationConfigurationResponse,
  CreateDataLakeExceptionSubscriptionResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateSubscriberResponse,
  ListSubscribersResponse,
  UpdateSubscriberRequest,
  DeleteCustomLogSourceRequest,
  DataLakeException,
  CreateAwsLogSourceResponse,
  LogSource,
  UntagResourceRequest,
  DeleteSubscriberResponse,
  UpdateDataLakeResponse,
  GetDataLakeExceptionSubscriptionResponse,
  CreateDataLakeExceptionSubscriptionRequest,
  ListSubscribersRequest,
  GetDataLakeSourcesResponse,
  TagResourceResponse,
  GetDataLakeOrganizationConfigurationRequest,
  GetSubscriberRequest,
  CreateDataLakeRequest,
  TagResourceRequest,
  UpdateDataLakeExceptionSubscriptionResponse,
  ListDataLakesResponse,
  UpdateSubscriberNotificationRequest,
  DeregisterDataLakeDelegatedAdministratorResponse,
  GetDataLakeSourcesRequest,
  UpdateDataLakeExceptionSubscriptionRequest,
  DeleteAwsLogSourceResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.securitylake.{
  SecurityLakeAsyncClientBuilder,
  SecurityLakeAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait SecurityLake extends AspectSupport[SecurityLake] {
  val api: SecurityLakeAsyncClient
  def createDataLake(
      request: zio.aws.securitylake.model.CreateDataLakeRequest
  ): IO[AwsError, zio.aws.securitylake.model.CreateDataLakeResponse.ReadOnly]
  def deleteSubscriberNotification(
      request: zio.aws.securitylake.model.DeleteSubscriberNotificationRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.DeleteSubscriberNotificationResponse.ReadOnly
  ]
  def deleteDataLake(
      request: zio.aws.securitylake.model.DeleteDataLakeRequest
  ): IO[AwsError, zio.aws.securitylake.model.DeleteDataLakeResponse.ReadOnly]
  def getDataLakeSources(
      request: zio.aws.securitylake.model.GetDataLakeSourcesRequest
  ): ZStream[Any, AwsError, zio.aws.securitylake.model.DataLakeSource.ReadOnly]
  def getDataLakeSourcesPaginated(
      request: zio.aws.securitylake.model.GetDataLakeSourcesRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.GetDataLakeSourcesResponse.ReadOnly
  ]
  def createDataLakeExceptionSubscription(
      request: zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionResponse.ReadOnly
  ]
  def updateSubscriberNotification(
      request: zio.aws.securitylake.model.UpdateSubscriberNotificationRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.UpdateSubscriberNotificationResponse.ReadOnly
  ]
  def createSubscriberNotification(
      request: zio.aws.securitylake.model.CreateSubscriberNotificationRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.CreateSubscriberNotificationResponse.ReadOnly
  ]
  def deleteSubscriber(
      request: zio.aws.securitylake.model.DeleteSubscriberRequest
  ): IO[AwsError, zio.aws.securitylake.model.DeleteSubscriberResponse.ReadOnly]
  def updateDataLakeExceptionSubscription(
      request: zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionResponse.ReadOnly
  ]
  def deregisterDataLakeDelegatedAdministrator(
      request: zio.aws.securitylake.model.DeregisterDataLakeDelegatedAdministratorRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.DeregisterDataLakeDelegatedAdministratorResponse.ReadOnly
  ]
  def registerDataLakeDelegatedAdministrator(
      request: zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorResponse.ReadOnly
  ]
  def createDataLakeOrganizationConfiguration(
      request: zio.aws.securitylake.model.CreateDataLakeOrganizationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.CreateDataLakeOrganizationConfigurationResponse.ReadOnly
  ]
  def deleteDataLakeOrganizationConfiguration(
      request: zio.aws.securitylake.model.DeleteDataLakeOrganizationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.DeleteDataLakeOrganizationConfigurationResponse.ReadOnly
  ]
  def getDataLakeExceptionSubscription(
      request: zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionResponse.ReadOnly
  ]
  def listLogSources(
      request: zio.aws.securitylake.model.ListLogSourcesRequest
  ): ZStream[Any, AwsError, zio.aws.securitylake.model.LogSource.ReadOnly]
  def listLogSourcesPaginated(
      request: zio.aws.securitylake.model.ListLogSourcesRequest
  ): IO[AwsError, zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly]
  def listDataLakeExceptions(
      request: zio.aws.securitylake.model.ListDataLakeExceptionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.securitylake.model.DataLakeException.ReadOnly
  ]
  def listDataLakeExceptionsPaginated(
      request: zio.aws.securitylake.model.ListDataLakeExceptionsRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.ListDataLakeExceptionsResponse.ReadOnly
  ]
  def getSubscriber(
      request: zio.aws.securitylake.model.GetSubscriberRequest
  ): IO[AwsError, zio.aws.securitylake.model.GetSubscriberResponse.ReadOnly]
  def deleteDataLakeExceptionSubscription(
      request: zio.aws.securitylake.model.DeleteDataLakeExceptionSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.DeleteDataLakeExceptionSubscriptionResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.securitylake.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.securitylake.model.UntagResourceResponse.ReadOnly]
  def deleteAwsLogSource(
      request: zio.aws.securitylake.model.DeleteAwsLogSourceRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.DeleteAwsLogSourceResponse.ReadOnly
  ]
  def updateSubscriber(
      request: zio.aws.securitylake.model.UpdateSubscriberRequest
  ): IO[AwsError, zio.aws.securitylake.model.UpdateSubscriberResponse.ReadOnly]
  def createCustomLogSource(
      request: zio.aws.securitylake.model.CreateCustomLogSourceRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly
  ]
  def listDataLakes(
      request: zio.aws.securitylake.model.ListDataLakesRequest
  ): IO[AwsError, zio.aws.securitylake.model.ListDataLakesResponse.ReadOnly]
  def createAwsLogSource(
      request: zio.aws.securitylake.model.CreateAwsLogSourceRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.securitylake.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.ListTagsForResourceResponse.ReadOnly
  ]
  def deleteCustomLogSource(
      request: zio.aws.securitylake.model.DeleteCustomLogSourceRequest
  ): IO[
    AwsError,
    zio.aws.securitylake.model.DeleteCustomLogSourceResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.securitylake.model.TagResourceRequest
  ): IO[AwsError, zio.aws.securitylake.model.TagResourceResponse.ReadOnly]
  def listSubscribers(
      request: zio.aws.securitylake.model.ListSubscribersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.securitylake.model.SubscriberResource.ReadOnly
  ]
  def listSubscribersPaginated(
      request: zio.aws.securitylake.model.ListSubscribersRequest
  ): IO[AwsError, zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly]
  def createSubscriber(
      request: zio.aws.securitylake.model.CreateSubscriberRequest
  ): IO[AwsError, zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly]
  def getDataLakeOrganizationConfiguration(
      request: zio.aws.securitylake.model.GetDataLakeOrganizationConfigurationRequest
  ): IO[AwsError, ReadOnly]
  def updateDataLake(
      request: zio.aws.securitylake.model.UpdateDataLakeRequest
  ): IO[AwsError, zio.aws.securitylake.model.UpdateDataLakeResponse.ReadOnly]
}
object SecurityLake {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SecurityLake] = customized(
    identity
  )
  def customized(
      customization: SecurityLakeAsyncClientBuilder => SecurityLakeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SecurityLake] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SecurityLakeAsyncClientBuilder => SecurityLakeAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, SecurityLake] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SecurityLakeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SecurityLakeAsyncClient, SecurityLakeAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      SecurityLakeAsyncClient,
      SecurityLakeAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new SecurityLakeImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class SecurityLakeImpl[R](
      override val api: SecurityLakeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SecurityLake
      with AwsServiceBase[R] {
    override val serviceName: String = "SecurityLake"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SecurityLakeImpl[R1] = new SecurityLakeImpl(api, newAspect, r)
    def createDataLake(
        request: zio.aws.securitylake.model.CreateDataLakeRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateDataLakeResponse.ReadOnly
    ] = asyncRequestResponse[CreateDataLakeRequest, CreateDataLakeResponse](
      "createDataLake",
      api.createDataLake
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.CreateDataLakeResponse.wrap)
      .provideEnvironment(r)
    def deleteSubscriberNotification(
        request: zio.aws.securitylake.model.DeleteSubscriberNotificationRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteSubscriberNotificationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteSubscriberNotificationRequest,
      DeleteSubscriberNotificationResponse
    ]("deleteSubscriberNotification", api.deleteSubscriberNotification)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.DeleteSubscriberNotificationResponse.wrap)
      .provideEnvironment(r)
    def deleteDataLake(
        request: zio.aws.securitylake.model.DeleteDataLakeRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteDataLakeResponse.ReadOnly
    ] = asyncRequestResponse[DeleteDataLakeRequest, DeleteDataLakeResponse](
      "deleteDataLake",
      api.deleteDataLake
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.DeleteDataLakeResponse.wrap)
      .provideEnvironment(r)
    def getDataLakeSources(
        request: zio.aws.securitylake.model.GetDataLakeSourcesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.securitylake.model.DataLakeSource.ReadOnly
    ] = asyncJavaPaginatedRequest[
      GetDataLakeSourcesRequest,
      DataLakeSource,
      GetDataLakeSourcesPublisher
    ](
      "getDataLakeSources",
      api.getDataLakeSourcesPaginator,
      _.dataLakeSources()
    )(request.buildAwsValue())
      .map(item => zio.aws.securitylake.model.DataLakeSource.wrap(item))
      .provideEnvironment(r)
    def getDataLakeSourcesPaginated(
        request: zio.aws.securitylake.model.GetDataLakeSourcesRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.GetDataLakeSourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDataLakeSourcesRequest,
      GetDataLakeSourcesResponse
    ]("getDataLakeSources", api.getDataLakeSources)(request.buildAwsValue())
      .map(zio.aws.securitylake.model.GetDataLakeSourcesResponse.wrap)
      .provideEnvironment(r)
    def createDataLakeExceptionSubscription(
        request: zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDataLakeExceptionSubscriptionRequest,
      CreateDataLakeExceptionSubscriptionResponse
    ](
      "createDataLakeExceptionSubscription",
      api.createDataLakeExceptionSubscription
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionResponse.wrap
      )
      .provideEnvironment(r)
    def updateSubscriberNotification(
        request: zio.aws.securitylake.model.UpdateSubscriberNotificationRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.UpdateSubscriberNotificationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSubscriberNotificationRequest,
      UpdateSubscriberNotificationResponse
    ]("updateSubscriberNotification", api.updateSubscriberNotification)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.UpdateSubscriberNotificationResponse.wrap)
      .provideEnvironment(r)
    def createSubscriberNotification(
        request: zio.aws.securitylake.model.CreateSubscriberNotificationRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateSubscriberNotificationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateSubscriberNotificationRequest,
      CreateSubscriberNotificationResponse
    ]("createSubscriberNotification", api.createSubscriberNotification)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.CreateSubscriberNotificationResponse.wrap)
      .provideEnvironment(r)
    def deleteSubscriber(
        request: zio.aws.securitylake.model.DeleteSubscriberRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteSubscriberResponse.ReadOnly
    ] = asyncRequestResponse[DeleteSubscriberRequest, DeleteSubscriberResponse](
      "deleteSubscriber",
      api.deleteSubscriber
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.DeleteSubscriberResponse.wrap)
      .provideEnvironment(r)
    def updateDataLakeExceptionSubscription(
        request: zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateDataLakeExceptionSubscriptionRequest,
      UpdateDataLakeExceptionSubscriptionResponse
    ](
      "updateDataLakeExceptionSubscription",
      api.updateDataLakeExceptionSubscription
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionResponse.wrap
      )
      .provideEnvironment(r)
    def deregisterDataLakeDelegatedAdministrator(
        request: zio.aws.securitylake.model.DeregisterDataLakeDelegatedAdministratorRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeregisterDataLakeDelegatedAdministratorResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterDataLakeDelegatedAdministratorRequest,
      DeregisterDataLakeDelegatedAdministratorResponse
    ](
      "deregisterDataLakeDelegatedAdministrator",
      api.deregisterDataLakeDelegatedAdministrator
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.DeregisterDataLakeDelegatedAdministratorResponse.wrap
      )
      .provideEnvironment(r)
    def registerDataLakeDelegatedAdministrator(
        request: zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterDataLakeDelegatedAdministratorRequest,
      RegisterDataLakeDelegatedAdministratorResponse
    ](
      "registerDataLakeDelegatedAdministrator",
      api.registerDataLakeDelegatedAdministrator
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorResponse.wrap
      )
      .provideEnvironment(r)
    def createDataLakeOrganizationConfiguration(
        request: zio.aws.securitylake.model.CreateDataLakeOrganizationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateDataLakeOrganizationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDataLakeOrganizationConfigurationRequest,
      CreateDataLakeOrganizationConfigurationResponse
    ](
      "createDataLakeOrganizationConfiguration",
      api.createDataLakeOrganizationConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.CreateDataLakeOrganizationConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteDataLakeOrganizationConfiguration(
        request: zio.aws.securitylake.model.DeleteDataLakeOrganizationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteDataLakeOrganizationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDataLakeOrganizationConfigurationRequest,
      DeleteDataLakeOrganizationConfigurationResponse
    ](
      "deleteDataLakeOrganizationConfiguration",
      api.deleteDataLakeOrganizationConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.DeleteDataLakeOrganizationConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getDataLakeExceptionSubscription(
        request: zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDataLakeExceptionSubscriptionRequest,
      GetDataLakeExceptionSubscriptionResponse
    ]("getDataLakeExceptionSubscription", api.getDataLakeExceptionSubscription)(
      request.buildAwsValue()
    ).map(
      zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionResponse.wrap
    ).provideEnvironment(r)
    def listLogSources(
        request: zio.aws.securitylake.model.ListLogSourcesRequest
    ): ZStream[Any, AwsError, zio.aws.securitylake.model.LogSource.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListLogSourcesRequest,
        LogSource,
        ListLogSourcesPublisher
      ]("listLogSources", api.listLogSourcesPaginator, _.sources())(
        request.buildAwsValue()
      ).map(item => zio.aws.securitylake.model.LogSource.wrap(item))
        .provideEnvironment(r)
    def listLogSourcesPaginated(
        request: zio.aws.securitylake.model.ListLogSourcesRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly
    ] = asyncRequestResponse[ListLogSourcesRequest, ListLogSourcesResponse](
      "listLogSources",
      api.listLogSources
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.ListLogSourcesResponse.wrap)
      .provideEnvironment(r)
    def listDataLakeExceptions(
        request: zio.aws.securitylake.model.ListDataLakeExceptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.securitylake.model.DataLakeException.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListDataLakeExceptionsRequest,
      DataLakeException,
      ListDataLakeExceptionsPublisher
    ](
      "listDataLakeExceptions",
      api.listDataLakeExceptionsPaginator,
      _.exceptions()
    )(request.buildAwsValue())
      .map(item => zio.aws.securitylake.model.DataLakeException.wrap(item))
      .provideEnvironment(r)
    def listDataLakeExceptionsPaginated(
        request: zio.aws.securitylake.model.ListDataLakeExceptionsRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.ListDataLakeExceptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDataLakeExceptionsRequest,
      ListDataLakeExceptionsResponse
    ]("listDataLakeExceptions", api.listDataLakeExceptions)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.ListDataLakeExceptionsResponse.wrap)
      .provideEnvironment(r)
    def getSubscriber(
        request: zio.aws.securitylake.model.GetSubscriberRequest
    ): IO[AwsError, zio.aws.securitylake.model.GetSubscriberResponse.ReadOnly] =
      asyncRequestResponse[GetSubscriberRequest, GetSubscriberResponse](
        "getSubscriber",
        api.getSubscriber
      )(request.buildAwsValue())
        .map(zio.aws.securitylake.model.GetSubscriberResponse.wrap)
        .provideEnvironment(r)
    def deleteDataLakeExceptionSubscription(
        request: zio.aws.securitylake.model.DeleteDataLakeExceptionSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteDataLakeExceptionSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDataLakeExceptionSubscriptionRequest,
      DeleteDataLakeExceptionSubscriptionResponse
    ](
      "deleteDataLakeExceptionSubscription",
      api.deleteDataLakeExceptionSubscription
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.DeleteDataLakeExceptionSubscriptionResponse.wrap
      )
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.securitylake.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.securitylake.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.securitylake.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteAwsLogSource(
        request: zio.aws.securitylake.model.DeleteAwsLogSourceRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteAwsLogSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteAwsLogSourceRequest,
      DeleteAwsLogSourceResponse
    ]("deleteAwsLogSource", api.deleteAwsLogSource)(request.buildAwsValue())
      .map(zio.aws.securitylake.model.DeleteAwsLogSourceResponse.wrap)
      .provideEnvironment(r)
    def updateSubscriber(
        request: zio.aws.securitylake.model.UpdateSubscriberRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.UpdateSubscriberResponse.ReadOnly
    ] = asyncRequestResponse[UpdateSubscriberRequest, UpdateSubscriberResponse](
      "updateSubscriber",
      api.updateSubscriber
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.UpdateSubscriberResponse.wrap)
      .provideEnvironment(r)
    def createCustomLogSource(
        request: zio.aws.securitylake.model.CreateCustomLogSourceRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCustomLogSourceRequest,
      CreateCustomLogSourceResponse
    ]("createCustomLogSource", api.createCustomLogSource)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.CreateCustomLogSourceResponse.wrap)
      .provideEnvironment(r)
    def listDataLakes(
        request: zio.aws.securitylake.model.ListDataLakesRequest
    ): IO[AwsError, zio.aws.securitylake.model.ListDataLakesResponse.ReadOnly] =
      asyncRequestResponse[ListDataLakesRequest, ListDataLakesResponse](
        "listDataLakes",
        api.listDataLakes
      )(request.buildAwsValue())
        .map(zio.aws.securitylake.model.ListDataLakesResponse.wrap)
        .provideEnvironment(r)
    def createAwsLogSource(
        request: zio.aws.securitylake.model.CreateAwsLogSourceRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateAwsLogSourceRequest,
      CreateAwsLogSourceResponse
    ]("createAwsLogSource", api.createAwsLogSource)(request.buildAwsValue())
      .map(zio.aws.securitylake.model.CreateAwsLogSourceResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.securitylake.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.securitylake.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteCustomLogSource(
        request: zio.aws.securitylake.model.DeleteCustomLogSourceRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.DeleteCustomLogSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteCustomLogSourceRequest,
      DeleteCustomLogSourceResponse
    ]("deleteCustomLogSource", api.deleteCustomLogSource)(
      request.buildAwsValue()
    ).map(zio.aws.securitylake.model.DeleteCustomLogSourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.securitylake.model.TagResourceRequest
    ): IO[AwsError, zio.aws.securitylake.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.securitylake.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listSubscribers(
        request: zio.aws.securitylake.model.ListSubscribersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.securitylake.model.SubscriberResource.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListSubscribersRequest,
      SubscriberResource,
      ListSubscribersPublisher
    ]("listSubscribers", api.listSubscribersPaginator, _.subscribers())(
      request.buildAwsValue()
    ).map(item => zio.aws.securitylake.model.SubscriberResource.wrap(item))
      .provideEnvironment(r)
    def listSubscribersPaginated(
        request: zio.aws.securitylake.model.ListSubscribersRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly
    ] = asyncRequestResponse[ListSubscribersRequest, ListSubscribersResponse](
      "listSubscribers",
      api.listSubscribers
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.ListSubscribersResponse.wrap)
      .provideEnvironment(r)
    def createSubscriber(
        request: zio.aws.securitylake.model.CreateSubscriberRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly
    ] = asyncRequestResponse[CreateSubscriberRequest, CreateSubscriberResponse](
      "createSubscriber",
      api.createSubscriber
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.CreateSubscriberResponse.wrap)
      .provideEnvironment(r)
    def getDataLakeOrganizationConfiguration(
        request: zio.aws.securitylake.model.GetDataLakeOrganizationConfigurationRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      GetDataLakeOrganizationConfigurationRequest,
      GetDataLakeOrganizationConfigurationResponse
    ](
      "getDataLakeOrganizationConfiguration",
      api.getDataLakeOrganizationConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.securitylake.model.GetDataLakeOrganizationConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def updateDataLake(
        request: zio.aws.securitylake.model.UpdateDataLakeRequest
    ): IO[
      AwsError,
      zio.aws.securitylake.model.UpdateDataLakeResponse.ReadOnly
    ] = asyncRequestResponse[UpdateDataLakeRequest, UpdateDataLakeResponse](
      "updateDataLake",
      api.updateDataLake
    )(request.buildAwsValue())
      .map(zio.aws.securitylake.model.UpdateDataLakeResponse.wrap)
      .provideEnvironment(r)
  }
  def createDataLake(
      request: zio.aws.securitylake.model.CreateDataLakeRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateDataLakeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataLake(request))
  def deleteSubscriberNotification(
      request: zio.aws.securitylake.model.DeleteSubscriberNotificationRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteSubscriberNotificationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSubscriberNotification(request))
  def deleteDataLake(
      request: zio.aws.securitylake.model.DeleteDataLakeRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteDataLakeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataLake(request))
  def getDataLakeSources(
      request: zio.aws.securitylake.model.GetDataLakeSourcesRequest
  ): ZStream[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DataLakeSource.ReadOnly
  ] = ZStream.serviceWithStream(_.getDataLakeSources(request))
  def getDataLakeSourcesPaginated(
      request: zio.aws.securitylake.model.GetDataLakeSourcesRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.GetDataLakeSourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataLakeSourcesPaginated(request))
  def createDataLakeExceptionSubscription(
      request: zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataLakeExceptionSubscription(request))
  def updateSubscriberNotification(
      request: zio.aws.securitylake.model.UpdateSubscriberNotificationRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.UpdateSubscriberNotificationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSubscriberNotification(request))
  def createSubscriberNotification(
      request: zio.aws.securitylake.model.CreateSubscriberNotificationRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateSubscriberNotificationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSubscriberNotification(request))
  def deleteSubscriber(
      request: zio.aws.securitylake.model.DeleteSubscriberRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteSubscriberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSubscriber(request))
  def updateDataLakeExceptionSubscription(
      request: zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDataLakeExceptionSubscription(request))
  def deregisterDataLakeDelegatedAdministrator(
      request: zio.aws.securitylake.model.DeregisterDataLakeDelegatedAdministratorRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeregisterDataLakeDelegatedAdministratorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterDataLakeDelegatedAdministrator(request))
  def registerDataLakeDelegatedAdministrator(
      request: zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerDataLakeDelegatedAdministrator(request))
  def createDataLakeOrganizationConfiguration(
      request: zio.aws.securitylake.model.CreateDataLakeOrganizationConfigurationRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateDataLakeOrganizationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataLakeOrganizationConfiguration(request))
  def deleteDataLakeOrganizationConfiguration(
      request: zio.aws.securitylake.model.DeleteDataLakeOrganizationConfigurationRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteDataLakeOrganizationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataLakeOrganizationConfiguration(request))
  def getDataLakeExceptionSubscription(
      request: zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataLakeExceptionSubscription(request))
  def listLogSources(
      request: zio.aws.securitylake.model.ListLogSourcesRequest
  ): ZStream[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.LogSource.ReadOnly
  ] = ZStream.serviceWithStream(_.listLogSources(request))
  def listLogSourcesPaginated(
      request: zio.aws.securitylake.model.ListLogSourcesRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLogSourcesPaginated(request))
  def listDataLakeExceptions(
      request: zio.aws.securitylake.model.ListDataLakeExceptionsRequest
  ): ZStream[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DataLakeException.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataLakeExceptions(request))
  def listDataLakeExceptionsPaginated(
      request: zio.aws.securitylake.model.ListDataLakeExceptionsRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.ListDataLakeExceptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataLakeExceptionsPaginated(request))
  def getSubscriber(
      request: zio.aws.securitylake.model.GetSubscriberRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.GetSubscriberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSubscriber(request))
  def deleteDataLakeExceptionSubscription(
      request: zio.aws.securitylake.model.DeleteDataLakeExceptionSubscriptionRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteDataLakeExceptionSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataLakeExceptionSubscription(request))
  def untagResource(
      request: zio.aws.securitylake.model.UntagResourceRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteAwsLogSource(
      request: zio.aws.securitylake.model.DeleteAwsLogSourceRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteAwsLogSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAwsLogSource(request))
  def updateSubscriber(
      request: zio.aws.securitylake.model.UpdateSubscriberRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.UpdateSubscriberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSubscriber(request))
  def createCustomLogSource(
      request: zio.aws.securitylake.model.CreateCustomLogSourceRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomLogSource(request))
  def listDataLakes(
      request: zio.aws.securitylake.model.ListDataLakesRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.ListDataLakesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataLakes(request))
  def createAwsLogSource(
      request: zio.aws.securitylake.model.CreateAwsLogSourceRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAwsLogSource(request))
  def listTagsForResource(
      request: zio.aws.securitylake.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteCustomLogSource(
      request: zio.aws.securitylake.model.DeleteCustomLogSourceRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.DeleteCustomLogSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCustomLogSource(request))
  def tagResource(request: zio.aws.securitylake.model.TagResourceRequest): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listSubscribers(
      request: zio.aws.securitylake.model.ListSubscribersRequest
  ): ZStream[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.SubscriberResource.ReadOnly
  ] = ZStream.serviceWithStream(_.listSubscribers(request))
  def listSubscribersPaginated(
      request: zio.aws.securitylake.model.ListSubscribersRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSubscribersPaginated(request))
  def createSubscriber(
      request: zio.aws.securitylake.model.CreateSubscriberRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSubscriber(request))
  def getDataLakeOrganizationConfiguration(
      request: zio.aws.securitylake.model.GetDataLakeOrganizationConfigurationRequest
  ): ZIO[zio.aws.securitylake.SecurityLake, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getDataLakeOrganizationConfiguration(request))
  def updateDataLake(
      request: zio.aws.securitylake.model.UpdateDataLakeRequest
  ): ZIO[
    zio.aws.securitylake.SecurityLake,
    AwsError,
    zio.aws.securitylake.model.UpdateDataLakeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDataLake(request))
}
