package zio.aws.securitylake
import zio.aws.securitylake.model.GetDataLakeOrganizationConfigurationResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.securitylake.SecurityLakeAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.securitylake.model.{
  DeleteSubscriberNotificationRequest,
  DeleteDataLakeExceptionSubscriptionRequest,
  DeleteAwsLogSourceRequest,
  CreateDataLakeOrganizationConfigurationRequest,
  CreateSubscriberRequest,
  DeregisterDataLakeDelegatedAdministratorRequest,
  CreateSubscriberNotificationRequest,
  CreateCustomLogSourceRequest,
  ListLogSourcesRequest,
  CreateAwsLogSourceRequest,
  ListTagsForResourceRequest,
  DeleteSubscriberRequest,
  RegisterDataLakeDelegatedAdministratorRequest,
  UpdateDataLakeRequest,
  ListDataLakesRequest,
  GetDataLakeExceptionSubscriptionRequest,
  ListDataLakeExceptionsRequest,
  DeleteDataLakeOrganizationConfigurationRequest,
  DeleteDataLakeRequest,
  UpdateSubscriberRequest,
  DeleteCustomLogSourceRequest,
  UntagResourceRequest,
  CreateDataLakeExceptionSubscriptionRequest,
  ListSubscribersRequest,
  GetDataLakeOrganizationConfigurationRequest,
  GetSubscriberRequest,
  CreateDataLakeRequest,
  TagResourceRequest,
  UpdateSubscriberNotificationRequest,
  GetDataLakeSourcesRequest,
  UpdateDataLakeExceptionSubscriptionRequest
}
object SecurityLakeMock extends Mock[SecurityLake] {
  object CreateDataLake
      extends Effect[
        CreateDataLakeRequest,
        AwsError,
        zio.aws.securitylake.model.CreateDataLakeResponse.ReadOnly
      ]
  object DeleteSubscriberNotification
      extends Effect[
        DeleteSubscriberNotificationRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteSubscriberNotificationResponse.ReadOnly
      ]
  object DeleteDataLake
      extends Effect[
        DeleteDataLakeRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteDataLakeResponse.ReadOnly
      ]
  object GetDataLakeSources
      extends Stream[
        GetDataLakeSourcesRequest,
        AwsError,
        zio.aws.securitylake.model.DataLakeSource.ReadOnly
      ]
  object GetDataLakeSourcesPaginated
      extends Effect[
        GetDataLakeSourcesRequest,
        AwsError,
        zio.aws.securitylake.model.GetDataLakeSourcesResponse.ReadOnly
      ]
  object CreateDataLakeExceptionSubscription
      extends Effect[
        CreateDataLakeExceptionSubscriptionRequest,
        AwsError,
        zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionResponse.ReadOnly
      ]
  object UpdateSubscriberNotification
      extends Effect[
        UpdateSubscriberNotificationRequest,
        AwsError,
        zio.aws.securitylake.model.UpdateSubscriberNotificationResponse.ReadOnly
      ]
  object CreateSubscriberNotification
      extends Effect[
        CreateSubscriberNotificationRequest,
        AwsError,
        zio.aws.securitylake.model.CreateSubscriberNotificationResponse.ReadOnly
      ]
  object DeleteSubscriber
      extends Effect[
        DeleteSubscriberRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteSubscriberResponse.ReadOnly
      ]
  object UpdateDataLakeExceptionSubscription
      extends Effect[
        UpdateDataLakeExceptionSubscriptionRequest,
        AwsError,
        zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionResponse.ReadOnly
      ]
  object DeregisterDataLakeDelegatedAdministrator
      extends Effect[
        DeregisterDataLakeDelegatedAdministratorRequest,
        AwsError,
        zio.aws.securitylake.model.DeregisterDataLakeDelegatedAdministratorResponse.ReadOnly
      ]
  object RegisterDataLakeDelegatedAdministrator
      extends Effect[
        RegisterDataLakeDelegatedAdministratorRequest,
        AwsError,
        zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorResponse.ReadOnly
      ]
  object CreateDataLakeOrganizationConfiguration
      extends Effect[
        CreateDataLakeOrganizationConfigurationRequest,
        AwsError,
        zio.aws.securitylake.model.CreateDataLakeOrganizationConfigurationResponse.ReadOnly
      ]
  object DeleteDataLakeOrganizationConfiguration
      extends Effect[
        DeleteDataLakeOrganizationConfigurationRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteDataLakeOrganizationConfigurationResponse.ReadOnly
      ]
  object GetDataLakeExceptionSubscription
      extends Effect[
        GetDataLakeExceptionSubscriptionRequest,
        AwsError,
        zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionResponse.ReadOnly
      ]
  object ListLogSources
      extends Stream[
        ListLogSourcesRequest,
        AwsError,
        zio.aws.securitylake.model.LogSource.ReadOnly
      ]
  object ListLogSourcesPaginated
      extends Effect[
        ListLogSourcesRequest,
        AwsError,
        zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly
      ]
  object ListDataLakeExceptions
      extends Stream[
        ListDataLakeExceptionsRequest,
        AwsError,
        zio.aws.securitylake.model.DataLakeException.ReadOnly
      ]
  object ListDataLakeExceptionsPaginated
      extends Effect[
        ListDataLakeExceptionsRequest,
        AwsError,
        zio.aws.securitylake.model.ListDataLakeExceptionsResponse.ReadOnly
      ]
  object GetSubscriber
      extends Effect[
        GetSubscriberRequest,
        AwsError,
        zio.aws.securitylake.model.GetSubscriberResponse.ReadOnly
      ]
  object DeleteDataLakeExceptionSubscription
      extends Effect[
        DeleteDataLakeExceptionSubscriptionRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteDataLakeExceptionSubscriptionResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.securitylake.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteAwsLogSource
      extends Effect[
        DeleteAwsLogSourceRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteAwsLogSourceResponse.ReadOnly
      ]
  object UpdateSubscriber
      extends Effect[
        UpdateSubscriberRequest,
        AwsError,
        zio.aws.securitylake.model.UpdateSubscriberResponse.ReadOnly
      ]
  object CreateCustomLogSource
      extends Effect[
        CreateCustomLogSourceRequest,
        AwsError,
        zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly
      ]
  object ListDataLakes
      extends Effect[
        ListDataLakesRequest,
        AwsError,
        zio.aws.securitylake.model.ListDataLakesResponse.ReadOnly
      ]
  object CreateAwsLogSource
      extends Effect[
        CreateAwsLogSourceRequest,
        AwsError,
        zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.securitylake.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteCustomLogSource
      extends Effect[
        DeleteCustomLogSourceRequest,
        AwsError,
        zio.aws.securitylake.model.DeleteCustomLogSourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.securitylake.model.TagResourceResponse.ReadOnly
      ]
  object ListSubscribers
      extends Stream[
        ListSubscribersRequest,
        AwsError,
        zio.aws.securitylake.model.SubscriberResource.ReadOnly
      ]
  object ListSubscribersPaginated
      extends Effect[
        ListSubscribersRequest,
        AwsError,
        zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly
      ]
  object CreateSubscriber
      extends Effect[
        CreateSubscriberRequest,
        AwsError,
        zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly
      ]
  object GetDataLakeOrganizationConfiguration
      extends Effect[
        GetDataLakeOrganizationConfigurationRequest,
        AwsError,
        ReadOnly
      ]
  object UpdateDataLake
      extends Effect[
        UpdateDataLakeRequest,
        AwsError,
        zio.aws.securitylake.model.UpdateDataLakeResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SecurityLake] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, SecurityLake] { rts =>
        zio.ZIO.succeed {
          new SecurityLake {
            val api: SecurityLakeAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): SecurityLake = this
            def createDataLake(request: CreateDataLakeRequest): IO[
              AwsError,
              zio.aws.securitylake.model.CreateDataLakeResponse.ReadOnly
            ] = proxy(CreateDataLake, request)
            def deleteSubscriberNotification(
                request: DeleteSubscriberNotificationRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteSubscriberNotificationResponse.ReadOnly
            ] = proxy(DeleteSubscriberNotification, request)
            def deleteDataLake(request: DeleteDataLakeRequest): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteDataLakeResponse.ReadOnly
            ] = proxy(DeleteDataLake, request)
            def getDataLakeSources(request: GetDataLakeSourcesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.securitylake.model.DataLakeSource.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetDataLakeSources, request)
                }
                .getOrThrowFiberFailure()
            }
            def getDataLakeSourcesPaginated(
                request: GetDataLakeSourcesRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.GetDataLakeSourcesResponse.ReadOnly
            ] = proxy(GetDataLakeSourcesPaginated, request)
            def createDataLakeExceptionSubscription(
                request: CreateDataLakeExceptionSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionResponse.ReadOnly
            ] = proxy(CreateDataLakeExceptionSubscription, request)
            def updateSubscriberNotification(
                request: UpdateSubscriberNotificationRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.UpdateSubscriberNotificationResponse.ReadOnly
            ] = proxy(UpdateSubscriberNotification, request)
            def createSubscriberNotification(
                request: CreateSubscriberNotificationRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.CreateSubscriberNotificationResponse.ReadOnly
            ] = proxy(CreateSubscriberNotification, request)
            def deleteSubscriber(request: DeleteSubscriberRequest): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteSubscriberResponse.ReadOnly
            ] = proxy(DeleteSubscriber, request)
            def updateDataLakeExceptionSubscription(
                request: UpdateDataLakeExceptionSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionResponse.ReadOnly
            ] = proxy(UpdateDataLakeExceptionSubscription, request)
            def deregisterDataLakeDelegatedAdministrator(
                request: DeregisterDataLakeDelegatedAdministratorRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.DeregisterDataLakeDelegatedAdministratorResponse.ReadOnly
            ] = proxy(DeregisterDataLakeDelegatedAdministrator, request)
            def registerDataLakeDelegatedAdministrator(
                request: RegisterDataLakeDelegatedAdministratorRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorResponse.ReadOnly
            ] = proxy(RegisterDataLakeDelegatedAdministrator, request)
            def createDataLakeOrganizationConfiguration(
                request: CreateDataLakeOrganizationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.CreateDataLakeOrganizationConfigurationResponse.ReadOnly
            ] = proxy(CreateDataLakeOrganizationConfiguration, request)
            def deleteDataLakeOrganizationConfiguration(
                request: DeleteDataLakeOrganizationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteDataLakeOrganizationConfigurationResponse.ReadOnly
            ] = proxy(DeleteDataLakeOrganizationConfiguration, request)
            def getDataLakeExceptionSubscription(
                request: GetDataLakeExceptionSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionResponse.ReadOnly
            ] = proxy(GetDataLakeExceptionSubscription, request)
            def listLogSources(request: ListLogSourcesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.securitylake.model.LogSource.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLogSources, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLogSourcesPaginated(request: ListLogSourcesRequest): IO[
              AwsError,
              zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly
            ] = proxy(ListLogSourcesPaginated, request)
            def listDataLakeExceptions(
                request: ListDataLakeExceptionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.securitylake.model.DataLakeException.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataLakeExceptions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataLakeExceptionsPaginated(
                request: ListDataLakeExceptionsRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.ListDataLakeExceptionsResponse.ReadOnly
            ] = proxy(ListDataLakeExceptionsPaginated, request)
            def getSubscriber(request: GetSubscriberRequest): IO[
              AwsError,
              zio.aws.securitylake.model.GetSubscriberResponse.ReadOnly
            ] = proxy(GetSubscriber, request)
            def deleteDataLakeExceptionSubscription(
                request: DeleteDataLakeExceptionSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteDataLakeExceptionSubscriptionResponse.ReadOnly
            ] = proxy(DeleteDataLakeExceptionSubscription, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.securitylake.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def deleteAwsLogSource(request: DeleteAwsLogSourceRequest): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteAwsLogSourceResponse.ReadOnly
            ] = proxy(DeleteAwsLogSource, request)
            def updateSubscriber(request: UpdateSubscriberRequest): IO[
              AwsError,
              zio.aws.securitylake.model.UpdateSubscriberResponse.ReadOnly
            ] = proxy(UpdateSubscriber, request)
            def createCustomLogSource(
                request: CreateCustomLogSourceRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly
            ] = proxy(CreateCustomLogSource, request)
            def listDataLakes(request: ListDataLakesRequest): IO[
              AwsError,
              zio.aws.securitylake.model.ListDataLakesResponse.ReadOnly
            ] = proxy(ListDataLakes, request)
            def createAwsLogSource(request: CreateAwsLogSourceRequest): IO[
              AwsError,
              zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly
            ] = proxy(CreateAwsLogSource, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.securitylake.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def deleteCustomLogSource(
                request: DeleteCustomLogSourceRequest
            ): IO[
              AwsError,
              zio.aws.securitylake.model.DeleteCustomLogSourceResponse.ReadOnly
            ] = proxy(DeleteCustomLogSource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.securitylake.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listSubscribers(request: ListSubscribersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.securitylake.model.SubscriberResource.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSubscribers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSubscribersPaginated(request: ListSubscribersRequest): IO[
              AwsError,
              zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly
            ] = proxy(ListSubscribersPaginated, request)
            def createSubscriber(request: CreateSubscriberRequest): IO[
              AwsError,
              zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly
            ] = proxy(CreateSubscriber, request)
            def getDataLakeOrganizationConfiguration(
                request: GetDataLakeOrganizationConfigurationRequest
            ): IO[AwsError, ReadOnly] =
              proxy(GetDataLakeOrganizationConfiguration, request)
            def updateDataLake(request: UpdateDataLakeRequest): IO[
              AwsError,
              zio.aws.securitylake.model.UpdateDataLakeResponse.ReadOnly
            ] = proxy(UpdateDataLake, request)
          }
        }
      }
    }
  }
}
