package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateAwsLogSourceRequest(
    sources: Iterable[zio.aws.securitylake.model.AwsLogSourceConfiguration]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest = {
    import CreateAwsLogSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest
      .builder()
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CreateAwsLogSourceRequest.ReadOnly =
    zio.aws.securitylake.model.CreateAwsLogSourceRequest.wrap(buildAwsValue())
}
object CreateAwsLogSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateAwsLogSourceRequest =
      zio.aws.securitylake.model.CreateAwsLogSourceRequest(sources.map { item =>
        item.asEditable
      })
    def sources
        : List[zio.aws.securitylake.model.AwsLogSourceConfiguration.ReadOnly]
    def getSources: ZIO[Any, Nothing, List[
      zio.aws.securitylake.model.AwsLogSourceConfiguration.ReadOnly
    ]] = ZIO.succeed(sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest
  ) extends zio.aws.securitylake.model.CreateAwsLogSourceRequest.ReadOnly {
    override val sources
        : List[zio.aws.securitylake.model.AwsLogSourceConfiguration.ReadOnly] =
      impl
        .sources()
        .asScala
        .map { item =>
          zio.aws.securitylake.model.AwsLogSourceConfiguration.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest
  ): zio.aws.securitylake.model.CreateAwsLogSourceRequest.ReadOnly =
    new Wrapper(impl)
}
