package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCustomLogSourceResponse(
    source: Optional[zio.aws.securitylake.model.CustomLogSourceResource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse = {
    import CreateCustomLogSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse
      .builder()
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly =
    zio.aws.securitylake.model.CreateCustomLogSourceResponse
      .wrap(buildAwsValue())
}
object CreateCustomLogSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateCustomLogSourceResponse =
      zio.aws.securitylake.model
        .CreateCustomLogSourceResponse(source.map(value => value.asEditable))
    def source
        : Optional[zio.aws.securitylake.model.CustomLogSourceResource.ReadOnly]
    def getSource: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.CustomLogSourceResource.ReadOnly
    ] = AwsError.unwrapOptionField("source", source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse
  ) extends zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly {
    override val source: Optional[
      zio.aws.securitylake.model.CustomLogSourceResource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value =>
        zio.aws.securitylake.model.CustomLogSourceResource.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse
  ): zio.aws.securitylake.model.CreateCustomLogSourceResponse.ReadOnly =
    new Wrapper(impl)
}
