package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDataLakeResponse(
    dataLakes: Optional[Iterable[zio.aws.securitylake.model.DataLakeResource]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateDataLakeResponse = {
    import CreateDataLakeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateDataLakeResponse
      .builder()
      .optionallyWith(
        dataLakes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataLakes)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.CreateDataLakeResponse.ReadOnly =
    zio.aws.securitylake.model.CreateDataLakeResponse.wrap(buildAwsValue())
}
object CreateDataLakeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateDataLakeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateDataLakeResponse =
      zio.aws.securitylake.model.CreateDataLakeResponse(
        dataLakes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dataLakes
        : Optional[List[zio.aws.securitylake.model.DataLakeResource.ReadOnly]]
    def getDataLakes: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.DataLakeResource.ReadOnly
    ]] = AwsError.unwrapOptionField("dataLakes", dataLakes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateDataLakeResponse
  ) extends zio.aws.securitylake.model.CreateDataLakeResponse.ReadOnly {
    override val dataLakes
        : Optional[List[zio.aws.securitylake.model.DataLakeResource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataLakes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.DataLakeResource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateDataLakeResponse
  ): zio.aws.securitylake.model.CreateDataLakeResponse.ReadOnly = new Wrapper(
    impl
  )
}
