package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSubscriberNotificationResponse(
    subscriberEndpoint: Optional[SafeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateSubscriberNotificationResponse = {
    import CreateSubscriberNotificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateSubscriberNotificationResponse
      .builder()
      .optionallyWith(
        subscriberEndpoint.map(value =>
          SafeString.unwrap(value): java.lang.String
        )
      )(_.subscriberEndpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CreateSubscriberNotificationResponse.ReadOnly =
    zio.aws.securitylake.model.CreateSubscriberNotificationResponse
      .wrap(buildAwsValue())
}
object CreateSubscriberNotificationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateSubscriberNotificationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.CreateSubscriberNotificationResponse =
      zio.aws.securitylake.model.CreateSubscriberNotificationResponse(
        subscriberEndpoint.map(value => value)
      )
    def subscriberEndpoint: Optional[SafeString]
    def getSubscriberEndpoint: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("subscriberEndpoint", subscriberEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateSubscriberNotificationResponse
  ) extends zio.aws.securitylake.model.CreateSubscriberNotificationResponse.ReadOnly {
    override val subscriberEndpoint: Optional[SafeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriberEndpoint())
        .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateSubscriberNotificationResponse
  ): zio.aws.securitylake.model.CreateSubscriberNotificationResponse.ReadOnly =
    new Wrapper(impl)
}
