package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  CreateSubscriberRequestSubscriberNameString,
  DescriptionString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSubscriberRequest(
    accessTypes: Optional[Iterable[zio.aws.securitylake.model.AccessType]] =
      Optional.Absent,
    sources: Iterable[zio.aws.securitylake.model.LogSourceResource],
    subscriberDescription: Optional[DescriptionString] = Optional.Absent,
    subscriberIdentity: zio.aws.securitylake.model.AwsIdentity,
    subscriberName: CreateSubscriberRequestSubscriberNameString,
    tags: Optional[Iterable[zio.aws.securitylake.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest = {
    import CreateSubscriberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest
      .builder()
      .optionallyWith(
        accessTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.accessTypesWithStrings)
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        subscriberDescription.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.subscriberDescription)
      .subscriberIdentity(subscriberIdentity.buildAwsValue())
      .subscriberName(
        CreateSubscriberRequestSubscriberNameString.unwrap(
          subscriberName
        ): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.CreateSubscriberRequest.ReadOnly =
    zio.aws.securitylake.model.CreateSubscriberRequest.wrap(buildAwsValue())
}
object CreateSubscriberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateSubscriberRequest =
      zio.aws.securitylake.model.CreateSubscriberRequest(
        accessTypes.map(value => value),
        sources.map { item =>
          item.asEditable
        },
        subscriberDescription.map(value => value),
        subscriberIdentity.asEditable,
        subscriberName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accessTypes: Optional[List[zio.aws.securitylake.model.AccessType]]
    def sources: List[zio.aws.securitylake.model.LogSourceResource.ReadOnly]
    def subscriberDescription: Optional[DescriptionString]
    def subscriberIdentity: zio.aws.securitylake.model.AwsIdentity.ReadOnly
    def subscriberName: CreateSubscriberRequestSubscriberNameString
    def tags: Optional[List[zio.aws.securitylake.model.Tag.ReadOnly]]
    def getAccessTypes
        : ZIO[Any, AwsError, List[zio.aws.securitylake.model.AccessType]] =
      AwsError.unwrapOptionField("accessTypes", accessTypes)
    def getSources: ZIO[Any, Nothing, List[
      zio.aws.securitylake.model.LogSourceResource.ReadOnly
    ]] = ZIO.succeed(sources)
    def getSubscriberDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("subscriberDescription", subscriberDescription)
    def getSubscriberIdentity
        : ZIO[Any, Nothing, zio.aws.securitylake.model.AwsIdentity.ReadOnly] =
      ZIO.succeed(subscriberIdentity)
    def getSubscriberName
        : ZIO[Any, Nothing, CreateSubscriberRequestSubscriberNameString] =
      ZIO.succeed(subscriberName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.securitylake.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest
  ) extends zio.aws.securitylake.model.CreateSubscriberRequest.ReadOnly {
    override val accessTypes
        : Optional[List[zio.aws.securitylake.model.AccessType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.AccessType.wrap(item)
          }.toList
        )
    override val sources
        : List[zio.aws.securitylake.model.LogSourceResource.ReadOnly] = impl
      .sources()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.LogSourceResource.wrap(item)
      }
      .toList
    override val subscriberDescription: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriberDescription())
        .map(value =>
          zio.aws.securitylake.model.primitives.DescriptionString(value)
        )
    override val subscriberIdentity
        : zio.aws.securitylake.model.AwsIdentity.ReadOnly =
      zio.aws.securitylake.model.AwsIdentity.wrap(impl.subscriberIdentity())
    override val subscriberName: CreateSubscriberRequestSubscriberNameString =
      zio.aws.securitylake.model.primitives
        .CreateSubscriberRequestSubscriberNameString(impl.subscriberName())
    override val tags: Optional[List[zio.aws.securitylake.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest
  ): zio.aws.securitylake.model.CreateSubscriberRequest.ReadOnly = new Wrapper(
    impl
  )
}
