package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSubscriberResponse(
    subscriber: Optional[zio.aws.securitylake.model.SubscriberResource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse = {
    import CreateSubscriberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse
      .builder()
      .optionallyWith(subscriber.map(value => value.buildAwsValue()))(
        _.subscriber
      )
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly =
    zio.aws.securitylake.model.CreateSubscriberResponse.wrap(buildAwsValue())
}
object CreateSubscriberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateSubscriberResponse =
      zio.aws.securitylake.model
        .CreateSubscriberResponse(subscriber.map(value => value.asEditable))
    def subscriber
        : Optional[zio.aws.securitylake.model.SubscriberResource.ReadOnly]
    def getSubscriber: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.SubscriberResource.ReadOnly
    ] = AwsError.unwrapOptionField("subscriber", subscriber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse
  ) extends zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly {
    override val subscriber
        : Optional[zio.aws.securitylake.model.SubscriberResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriber())
        .map(value => zio.aws.securitylake.model.SubscriberResource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse
  ): zio.aws.securitylake.model.CreateSubscriberResponse.ReadOnly = new Wrapper(
    impl
  )
}
