package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomLogSourceAttributes(
    crawlerArn: Optional[AmazonResourceName] = Optional.Absent,
    databaseArn: Optional[AmazonResourceName] = Optional.Absent,
    tableArn: Optional[AmazonResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CustomLogSourceAttributes = {
    import CustomLogSourceAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CustomLogSourceAttributes
      .builder()
      .optionallyWith(
        crawlerArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.crawlerArn)
      .optionallyWith(
        databaseArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.databaseArn)
      .optionallyWith(
        tableArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.tableArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CustomLogSourceAttributes.ReadOnly =
    zio.aws.securitylake.model.CustomLogSourceAttributes.wrap(buildAwsValue())
}
object CustomLogSourceAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CustomLogSourceAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CustomLogSourceAttributes =
      zio.aws.securitylake.model.CustomLogSourceAttributes(
        crawlerArn.map(value => value),
        databaseArn.map(value => value),
        tableArn.map(value => value)
      )
    def crawlerArn: Optional[AmazonResourceName]
    def databaseArn: Optional[AmazonResourceName]
    def tableArn: Optional[AmazonResourceName]
    def getCrawlerArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("crawlerArn", crawlerArn)
    def getDatabaseArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("databaseArn", databaseArn)
    def getTableArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("tableArn", tableArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CustomLogSourceAttributes
  ) extends zio.aws.securitylake.model.CustomLogSourceAttributes.ReadOnly {
    override val crawlerArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crawlerArn())
        .map(value =>
          zio.aws.securitylake.model.primitives.AmazonResourceName(value)
        )
    override val databaseArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseArn())
        .map(value =>
          zio.aws.securitylake.model.primitives.AmazonResourceName(value)
        )
    override val tableArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableArn())
      .map(value =>
        zio.aws.securitylake.model.primitives.AmazonResourceName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CustomLogSourceAttributes
  ): zio.aws.securitylake.model.CustomLogSourceAttributes.ReadOnly =
    new Wrapper(impl)
}
