package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.Region
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DataLakeAutoEnableNewAccountConfiguration(
    region: Region,
    sources: Iterable[zio.aws.securitylake.model.AwsLogSourceResource]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DataLakeAutoEnableNewAccountConfiguration = {
    import DataLakeAutoEnableNewAccountConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DataLakeAutoEnableNewAccountConfiguration
      .builder()
      .region(Region.unwrap(region): java.lang.String)
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DataLakeAutoEnableNewAccountConfiguration.ReadOnly =
    zio.aws.securitylake.model.DataLakeAutoEnableNewAccountConfiguration
      .wrap(buildAwsValue())
}
object DataLakeAutoEnableNewAccountConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DataLakeAutoEnableNewAccountConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.DataLakeAutoEnableNewAccountConfiguration =
      zio.aws.securitylake.model.DataLakeAutoEnableNewAccountConfiguration(
        region,
        sources.map { item =>
          item.asEditable
        }
      )
    def region: Region
    def sources: List[zio.aws.securitylake.model.AwsLogSourceResource.ReadOnly]
    def getRegion: ZIO[Any, Nothing, Region] = ZIO.succeed(region)
    def getSources: ZIO[Any, Nothing, List[
      zio.aws.securitylake.model.AwsLogSourceResource.ReadOnly
    ]] = ZIO.succeed(sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeAutoEnableNewAccountConfiguration
  ) extends zio.aws.securitylake.model.DataLakeAutoEnableNewAccountConfiguration.ReadOnly {
    override val region: Region =
      zio.aws.securitylake.model.primitives.Region(impl.region())
    override val sources
        : List[zio.aws.securitylake.model.AwsLogSourceResource.ReadOnly] = impl
      .sources()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.AwsLogSourceResource.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeAutoEnableNewAccountConfiguration
  ): zio.aws.securitylake.model.DataLakeAutoEnableNewAccountConfiguration.ReadOnly =
    new Wrapper(impl)
}
