package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.Region
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataLakeConfiguration(
    encryptionConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeEncryptionConfiguration
    ] = Optional.Absent,
    lifecycleConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeLifecycleConfiguration
    ] = Optional.Absent,
    region: Region,
    replicationConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeReplicationConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DataLakeConfiguration = {
    import DataLakeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DataLakeConfiguration
      .builder()
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        lifecycleConfiguration.map(value => value.buildAwsValue())
      )(_.lifecycleConfiguration)
      .region(Region.unwrap(region): java.lang.String)
      .optionallyWith(
        replicationConfiguration.map(value => value.buildAwsValue())
      )(_.replicationConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.DataLakeConfiguration.ReadOnly =
    zio.aws.securitylake.model.DataLakeConfiguration.wrap(buildAwsValue())
}
object DataLakeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DataLakeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DataLakeConfiguration =
      zio.aws.securitylake.model.DataLakeConfiguration(
        encryptionConfiguration.map(value => value.asEditable),
        lifecycleConfiguration.map(value => value.asEditable),
        region,
        replicationConfiguration.map(value => value.asEditable)
      )
    def encryptionConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeEncryptionConfiguration.ReadOnly
    ]
    def lifecycleConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeLifecycleConfiguration.ReadOnly
    ]
    def region: Region
    def replicationConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeReplicationConfiguration.ReadOnly
    ]
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.DataLakeEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getLifecycleConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.DataLakeLifecycleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lifecycleConfiguration",
      lifecycleConfiguration
    )
    def getRegion: ZIO[Any, Nothing, Region] = ZIO.succeed(region)
    def getReplicationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.DataLakeReplicationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicationConfiguration",
      replicationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeConfiguration
  ) extends zio.aws.securitylake.model.DataLakeConfiguration.ReadOnly {
    override val encryptionConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionConfiguration())
      .map(value =>
        zio.aws.securitylake.model.DataLakeEncryptionConfiguration.wrap(value)
      )
    override val lifecycleConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeLifecycleConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecycleConfiguration())
      .map(value =>
        zio.aws.securitylake.model.DataLakeLifecycleConfiguration.wrap(value)
      )
    override val region: Region =
      zio.aws.securitylake.model.primitives.Region(impl.region())
    override val replicationConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeReplicationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationConfiguration())
      .map(value =>
        zio.aws.securitylake.model.DataLakeReplicationConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeConfiguration
  ): zio.aws.securitylake.model.DataLakeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
