package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataLakeEncryptionConfiguration(
    kmsKeyId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DataLakeEncryptionConfiguration = {
    import DataLakeEncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DataLakeEncryptionConfiguration
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DataLakeEncryptionConfiguration.ReadOnly =
    zio.aws.securitylake.model.DataLakeEncryptionConfiguration
      .wrap(buildAwsValue())
}
object DataLakeEncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DataLakeEncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DataLakeEncryptionConfiguration =
      zio.aws.securitylake.model
        .DataLakeEncryptionConfiguration(kmsKeyId.map(value => value))
    def kmsKeyId: Optional[String]
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeEncryptionConfiguration
  ) extends zio.aws.securitylake.model.DataLakeEncryptionConfiguration.ReadOnly {
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeEncryptionConfiguration
  ): zio.aws.securitylake.model.DataLakeEncryptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
