package zio.aws.securitylake.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.securitylake.model.primitives.{
  SyntheticTimestamp_date_time,
  Region,
  SafeString
}
import scala.jdk.CollectionConverters.*
final case class DataLakeException(
    exception: Optional[SafeString] = Optional.Absent,
    region: Optional[Region] = Optional.Absent,
    remediation: Optional[SafeString] = Optional.Absent,
    timestamp: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DataLakeException = {
    import DataLakeException.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DataLakeException
      .builder()
      .optionallyWith(
        exception.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.exception)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        remediation.map(value => SafeString.unwrap(value): java.lang.String)
      )(_.remediation)
      .optionallyWith(
        timestamp.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.timestamp)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.DataLakeException.ReadOnly =
    zio.aws.securitylake.model.DataLakeException.wrap(buildAwsValue())
}
object DataLakeException {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DataLakeException
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DataLakeException =
      zio.aws.securitylake.model.DataLakeException(
        exception.map(value => value),
        region.map(value => value),
        remediation.map(value => value),
        timestamp.map(value => value)
      )
    def exception: Optional[SafeString]
    def region: Optional[Region]
    def remediation: Optional[SafeString]
    def timestamp: Optional[SyntheticTimestamp_date_time]
    def getException: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("exception", exception)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getRemediation: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("remediation", remediation)
    def getTimestamp: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeException
  ) extends zio.aws.securitylake.model.DataLakeException.ReadOnly {
    override val exception: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.exception())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.securitylake.model.primitives.Region(value))
    override val remediation: Optional[SafeString] = zio.aws.core.internal
      .optionalFromNullable(impl.remediation())
      .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
    override val timestamp: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timestamp())
        .map(value =>
          zio.aws.securitylake.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeException
  ): zio.aws.securitylake.model.DataLakeException.ReadOnly = new Wrapper(impl)
}
