package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataLakeLifecycleConfiguration(
    expiration: Optional[
      zio.aws.securitylake.model.DataLakeLifecycleExpiration
    ] = Optional.Absent,
    transitions: Optional[
      Iterable[zio.aws.securitylake.model.DataLakeLifecycleTransition]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleConfiguration = {
    import DataLakeLifecycleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleConfiguration
      .builder()
      .optionallyWith(expiration.map(value => value.buildAwsValue()))(
        _.expiration
      )
      .optionallyWith(
        transitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitions)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DataLakeLifecycleConfiguration.ReadOnly =
    zio.aws.securitylake.model.DataLakeLifecycleConfiguration
      .wrap(buildAwsValue())
}
object DataLakeLifecycleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DataLakeLifecycleConfiguration =
      zio.aws.securitylake.model.DataLakeLifecycleConfiguration(
        expiration.map(value => value.asEditable),
        transitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def expiration: Optional[
      zio.aws.securitylake.model.DataLakeLifecycleExpiration.ReadOnly
    ]
    def transitions: Optional[
      List[zio.aws.securitylake.model.DataLakeLifecycleTransition.ReadOnly]
    ]
    def getExpiration: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.DataLakeLifecycleExpiration.ReadOnly
    ] = AwsError.unwrapOptionField("expiration", expiration)
    def getTransitions: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.DataLakeLifecycleTransition.ReadOnly
    ]] = AwsError.unwrapOptionField("transitions", transitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleConfiguration
  ) extends zio.aws.securitylake.model.DataLakeLifecycleConfiguration.ReadOnly {
    override val expiration: Optional[
      zio.aws.securitylake.model.DataLakeLifecycleExpiration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.expiration())
      .map(value =>
        zio.aws.securitylake.model.DataLakeLifecycleExpiration.wrap(value)
      )
    override val transitions: Optional[
      List[zio.aws.securitylake.model.DataLakeLifecycleTransition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.DataLakeLifecycleTransition.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleConfiguration
  ): zio.aws.securitylake.model.DataLakeLifecycleConfiguration.ReadOnly =
    new Wrapper(impl)
}
