package zio.aws.securitylake.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.securitylake.model.primitives.DataLakeLifecycleExpirationDaysInteger
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DataLakeLifecycleExpiration(
    days: Optional[DataLakeLifecycleExpirationDaysInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleExpiration = {
    import DataLakeLifecycleExpiration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleExpiration
      .builder()
      .optionallyWith(
        days.map(value =>
          DataLakeLifecycleExpirationDaysInteger.unwrap(value): Integer
        )
      )(_.days)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DataLakeLifecycleExpiration.ReadOnly =
    zio.aws.securitylake.model.DataLakeLifecycleExpiration.wrap(buildAwsValue())
}
object DataLakeLifecycleExpiration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleExpiration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DataLakeLifecycleExpiration =
      zio.aws.securitylake.model
        .DataLakeLifecycleExpiration(days.map(value => value))
    def days: Optional[DataLakeLifecycleExpirationDaysInteger]
    def getDays: ZIO[Any, AwsError, DataLakeLifecycleExpirationDaysInteger] =
      AwsError.unwrapOptionField("days", days)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleExpiration
  ) extends zio.aws.securitylake.model.DataLakeLifecycleExpiration.ReadOnly {
    override val days: Optional[DataLakeLifecycleExpirationDaysInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.days())
        .map(value =>
          zio.aws.securitylake.model.primitives
            .DataLakeLifecycleExpirationDaysInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleExpiration
  ): zio.aws.securitylake.model.DataLakeLifecycleExpiration.ReadOnly =
    new Wrapper(impl)
}
