package zio.aws.securitylake.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.securitylake.model.primitives.{
  DataLakeStorageClass,
  DataLakeLifecycleTransitionDaysInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DataLakeLifecycleTransition(
    days: Optional[DataLakeLifecycleTransitionDaysInteger] = Optional.Absent,
    storageClass: Optional[DataLakeStorageClass] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleTransition = {
    import DataLakeLifecycleTransition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleTransition
      .builder()
      .optionallyWith(
        days.map(value =>
          DataLakeLifecycleTransitionDaysInteger.unwrap(value): Integer
        )
      )(_.days)
      .optionallyWith(
        storageClass.map(value =>
          DataLakeStorageClass.unwrap(value): java.lang.String
        )
      )(_.storageClass)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DataLakeLifecycleTransition.ReadOnly =
    zio.aws.securitylake.model.DataLakeLifecycleTransition.wrap(buildAwsValue())
}
object DataLakeLifecycleTransition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleTransition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DataLakeLifecycleTransition =
      zio.aws.securitylake.model.DataLakeLifecycleTransition(
        days.map(value => value),
        storageClass.map(value => value)
      )
    def days: Optional[DataLakeLifecycleTransitionDaysInteger]
    def storageClass: Optional[DataLakeStorageClass]
    def getDays: ZIO[Any, AwsError, DataLakeLifecycleTransitionDaysInteger] =
      AwsError.unwrapOptionField("days", days)
    def getStorageClass: ZIO[Any, AwsError, DataLakeStorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleTransition
  ) extends zio.aws.securitylake.model.DataLakeLifecycleTransition.ReadOnly {
    override val days: Optional[DataLakeLifecycleTransitionDaysInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.days())
        .map(value =>
          zio.aws.securitylake.model.primitives
            .DataLakeLifecycleTransitionDaysInteger(value)
        )
    override val storageClass: Optional[DataLakeStorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value =>
          zio.aws.securitylake.model.primitives.DataLakeStorageClass(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleTransition
  ): zio.aws.securitylake.model.DataLakeLifecycleTransition.ReadOnly =
    new Wrapper(impl)
}
