package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  S3BucketArn,
  Region,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataLakeResource(
    createStatus: Optional[zio.aws.securitylake.model.DataLakeStatus] =
      Optional.Absent,
    dataLakeArn: AmazonResourceName,
    encryptionConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeEncryptionConfiguration
    ] = Optional.Absent,
    lifecycleConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeLifecycleConfiguration
    ] = Optional.Absent,
    region: Region,
    replicationConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeReplicationConfiguration
    ] = Optional.Absent,
    s3BucketArn: Optional[S3BucketArn] = Optional.Absent,
    updateStatus: Optional[zio.aws.securitylake.model.DataLakeUpdateStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DataLakeResource = {
    import DataLakeResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DataLakeResource
      .builder()
      .optionallyWith(createStatus.map(value => value.unwrap))(_.createStatus)
      .dataLakeArn(AmazonResourceName.unwrap(dataLakeArn): java.lang.String)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        lifecycleConfiguration.map(value => value.buildAwsValue())
      )(_.lifecycleConfiguration)
      .region(Region.unwrap(region): java.lang.String)
      .optionallyWith(
        replicationConfiguration.map(value => value.buildAwsValue())
      )(_.replicationConfiguration)
      .optionallyWith(
        s3BucketArn.map(value => S3BucketArn.unwrap(value): java.lang.String)
      )(_.s3BucketArn)
      .optionallyWith(updateStatus.map(value => value.buildAwsValue()))(
        _.updateStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.DataLakeResource.ReadOnly =
    zio.aws.securitylake.model.DataLakeResource.wrap(buildAwsValue())
}
object DataLakeResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DataLakeResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DataLakeResource =
      zio.aws.securitylake.model.DataLakeResource(
        createStatus.map(value => value),
        dataLakeArn,
        encryptionConfiguration.map(value => value.asEditable),
        lifecycleConfiguration.map(value => value.asEditable),
        region,
        replicationConfiguration.map(value => value.asEditable),
        s3BucketArn.map(value => value),
        updateStatus.map(value => value.asEditable)
      )
    def createStatus: Optional[zio.aws.securitylake.model.DataLakeStatus]
    def dataLakeArn: AmazonResourceName
    def encryptionConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeEncryptionConfiguration.ReadOnly
    ]
    def lifecycleConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeLifecycleConfiguration.ReadOnly
    ]
    def region: Region
    def replicationConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeReplicationConfiguration.ReadOnly
    ]
    def s3BucketArn: Optional[S3BucketArn]
    def updateStatus
        : Optional[zio.aws.securitylake.model.DataLakeUpdateStatus.ReadOnly]
    def getCreateStatus
        : ZIO[Any, AwsError, zio.aws.securitylake.model.DataLakeStatus] =
      AwsError.unwrapOptionField("createStatus", createStatus)
    def getDataLakeArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(dataLakeArn)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.DataLakeEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getLifecycleConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.DataLakeLifecycleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lifecycleConfiguration",
      lifecycleConfiguration
    )
    def getRegion: ZIO[Any, Nothing, Region] = ZIO.succeed(region)
    def getReplicationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.DataLakeReplicationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicationConfiguration",
      replicationConfiguration
    )
    def getS3BucketArn: ZIO[Any, AwsError, S3BucketArn] =
      AwsError.unwrapOptionField("s3BucketArn", s3BucketArn)
    def getUpdateStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.DataLakeUpdateStatus.ReadOnly
    ] = AwsError.unwrapOptionField("updateStatus", updateStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeResource
  ) extends zio.aws.securitylake.model.DataLakeResource.ReadOnly {
    override val createStatus
        : Optional[zio.aws.securitylake.model.DataLakeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createStatus())
        .map(value => zio.aws.securitylake.model.DataLakeStatus.wrap(value))
    override val dataLakeArn: AmazonResourceName =
      zio.aws.securitylake.model.primitives
        .AmazonResourceName(impl.dataLakeArn())
    override val encryptionConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionConfiguration())
      .map(value =>
        zio.aws.securitylake.model.DataLakeEncryptionConfiguration.wrap(value)
      )
    override val lifecycleConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeLifecycleConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecycleConfiguration())
      .map(value =>
        zio.aws.securitylake.model.DataLakeLifecycleConfiguration.wrap(value)
      )
    override val region: Region =
      zio.aws.securitylake.model.primitives.Region(impl.region())
    override val replicationConfiguration: Optional[
      zio.aws.securitylake.model.DataLakeReplicationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationConfiguration())
      .map(value =>
        zio.aws.securitylake.model.DataLakeReplicationConfiguration.wrap(value)
      )
    override val s3BucketArn: Optional[S3BucketArn] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketArn())
      .map(value => zio.aws.securitylake.model.primitives.S3BucketArn(value))
    override val updateStatus
        : Optional[zio.aws.securitylake.model.DataLakeUpdateStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateStatus())
        .map(value =>
          zio.aws.securitylake.model.DataLakeUpdateStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeResource
  ): zio.aws.securitylake.model.DataLakeResource.ReadOnly = new Wrapper(impl)
}
