package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.OcsfEventClass
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataLakeSource(
    account: Optional[String] = Optional.Absent,
    eventClasses: Optional[Iterable[OcsfEventClass]] = Optional.Absent,
    sourceName: Optional[String] = Optional.Absent,
    sourceStatuses: Optional[
      Iterable[zio.aws.securitylake.model.DataLakeSourceStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DataLakeSource = {
    import DataLakeSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DataLakeSource
      .builder()
      .optionallyWith(account.map(value => value: java.lang.String))(_.account)
      .optionallyWith(
        eventClasses.map(value =>
          value.map { item =>
            OcsfEventClass.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.eventClasses)
      .optionallyWith(sourceName.map(value => value: java.lang.String))(
        _.sourceName
      )
      .optionallyWith(
        sourceStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceStatuses)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.DataLakeSource.ReadOnly =
    zio.aws.securitylake.model.DataLakeSource.wrap(buildAwsValue())
}
object DataLakeSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DataLakeSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DataLakeSource =
      zio.aws.securitylake.model.DataLakeSource(
        account.map(value => value),
        eventClasses.map(value => value),
        sourceName.map(value => value),
        sourceStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def account: Optional[String]
    def eventClasses: Optional[List[OcsfEventClass]]
    def sourceName: Optional[String]
    def sourceStatuses: Optional[
      List[zio.aws.securitylake.model.DataLakeSourceStatus.ReadOnly]
    ]
    def getAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("account", account)
    def getEventClasses: ZIO[Any, AwsError, List[OcsfEventClass]] =
      AwsError.unwrapOptionField("eventClasses", eventClasses)
    def getSourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceName", sourceName)
    def getSourceStatuses: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.DataLakeSourceStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceStatuses", sourceStatuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeSource
  ) extends zio.aws.securitylake.model.DataLakeSource.ReadOnly {
    override val account: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.account())
      .map(value => value: String)
    override val eventClasses: Optional[List[OcsfEventClass]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventClasses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.primitives.OcsfEventClass(item)
          }.toList
        )
    override val sourceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceName())
      .map(value => value: String)
    override val sourceStatuses: Optional[
      List[zio.aws.securitylake.model.DataLakeSourceStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.DataLakeSourceStatus.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeSource
  ): zio.aws.securitylake.model.DataLakeSource.ReadOnly = new Wrapper(impl)
}
