package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataLakeSourceStatus(
    resource: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.securitylake.model.SourceCollectionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DataLakeSourceStatus = {
    import DataLakeSourceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DataLakeSourceStatus
      .builder()
      .optionallyWith(resource.map(value => value: java.lang.String))(
        _.resource
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.DataLakeSourceStatus.ReadOnly =
    zio.aws.securitylake.model.DataLakeSourceStatus.wrap(buildAwsValue())
}
object DataLakeSourceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DataLakeSourceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DataLakeSourceStatus =
      zio.aws.securitylake.model.DataLakeSourceStatus(
        resource.map(value => value),
        status.map(value => value)
      )
    def resource: Optional[String]
    def status: Optional[zio.aws.securitylake.model.SourceCollectionStatus]
    def getResource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resource", resource)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.SourceCollectionStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeSourceStatus
  ) extends zio.aws.securitylake.model.DataLakeSourceStatus.ReadOnly {
    override val resource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.securitylake.model.SourceCollectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.securitylake.model.SourceCollectionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeSourceStatus
  ): zio.aws.securitylake.model.DataLakeSourceStatus.ReadOnly = new Wrapper(
    impl
  )
}
