package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.AwsAccountId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteAwsLogSourceResponse(
    failed: Optional[Iterable[AwsAccountId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceResponse = {
    import DeleteAwsLogSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceResponse
      .builder()
      .optionallyWith(
        failed.map(value =>
          value.map { item =>
            AwsAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.failed)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DeleteAwsLogSourceResponse.ReadOnly =
    zio.aws.securitylake.model.DeleteAwsLogSourceResponse.wrap(buildAwsValue())
}
object DeleteAwsLogSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DeleteAwsLogSourceResponse =
      zio.aws.securitylake.model
        .DeleteAwsLogSourceResponse(failed.map(value => value))
    def failed: Optional[List[AwsAccountId]]
    def getFailed: ZIO[Any, AwsError, List[AwsAccountId]] =
      AwsError.unwrapOptionField("failed", failed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceResponse
  ) extends zio.aws.securitylake.model.DeleteAwsLogSourceResponse.ReadOnly {
    override val failed: Optional[List[AwsAccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.failed())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.primitives.AwsAccountId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceResponse
  ): zio.aws.securitylake.model.DeleteAwsLogSourceResponse.ReadOnly =
    new Wrapper(impl)
}
