package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.Region
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDataLakeRequest(regions: Iterable[Region]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DeleteDataLakeRequest = {
    import DeleteDataLakeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DeleteDataLakeRequest
      .builder()
      .regions(regions.map { item =>
        Region.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.DeleteDataLakeRequest.ReadOnly =
    zio.aws.securitylake.model.DeleteDataLakeRequest.wrap(buildAwsValue())
}
object DeleteDataLakeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DeleteDataLakeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DeleteDataLakeRequest =
      zio.aws.securitylake.model.DeleteDataLakeRequest(regions)
    def regions: List[Region]
    def getRegions: ZIO[Any, Nothing, List[Region]] = ZIO.succeed(regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteDataLakeRequest
  ) extends zio.aws.securitylake.model.DeleteDataLakeRequest.ReadOnly {
    override val regions: List[Region] = impl
      .regions()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.primitives.Region(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteDataLakeRequest
  ): zio.aws.securitylake.model.DeleteDataLakeRequest.ReadOnly = new Wrapper(
    impl
  )
}
