package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.UUID
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSubscriberNotificationRequest(subscriberId: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DeleteSubscriberNotificationRequest = {
    import DeleteSubscriberNotificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DeleteSubscriberNotificationRequest
      .builder()
      .subscriberId(UUID.unwrap(subscriberId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DeleteSubscriberNotificationRequest.ReadOnly =
    zio.aws.securitylake.model.DeleteSubscriberNotificationRequest
      .wrap(buildAwsValue())
}
object DeleteSubscriberNotificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DeleteSubscriberNotificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.DeleteSubscriberNotificationRequest =
      zio.aws.securitylake.model
        .DeleteSubscriberNotificationRequest(subscriberId)
    def subscriberId: UUID
    def getSubscriberId: ZIO[Any, Nothing, UUID] = ZIO.succeed(subscriberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteSubscriberNotificationRequest
  ) extends zio.aws.securitylake.model.DeleteSubscriberNotificationRequest.ReadOnly {
    override val subscriberId: UUID =
      zio.aws.securitylake.model.primitives.UUID(impl.subscriberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteSubscriberNotificationRequest
  ): zio.aws.securitylake.model.DeleteSubscriberNotificationRequest.ReadOnly =
    new Wrapper(impl)
}
