package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.UUID
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSubscriberRequest(subscriberId: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DeleteSubscriberRequest = {
    import DeleteSubscriberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DeleteSubscriberRequest
      .builder()
      .subscriberId(UUID.unwrap(subscriberId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.DeleteSubscriberRequest.ReadOnly =
    zio.aws.securitylake.model.DeleteSubscriberRequest.wrap(buildAwsValue())
}
object DeleteSubscriberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DeleteSubscriberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DeleteSubscriberRequest =
      zio.aws.securitylake.model.DeleteSubscriberRequest(subscriberId)
    def subscriberId: UUID
    def getSubscriberId: ZIO[Any, Nothing, UUID] = ZIO.succeed(subscriberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteSubscriberRequest
  ) extends zio.aws.securitylake.model.DeleteSubscriberRequest.ReadOnly {
    override val subscriberId: UUID =
      zio.aws.securitylake.model.primitives.UUID(impl.subscriberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteSubscriberRequest
  ): zio.aws.securitylake.model.DeleteSubscriberRequest.ReadOnly = new Wrapper(
    impl
  )
}
