package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{SubscriptionProtocol, SafeString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDataLakeExceptionSubscriptionResponse(
    exceptionTimeToLive: Optional[Long] = Optional.Absent,
    notificationEndpoint: Optional[SafeString] = Optional.Absent,
    subscriptionProtocol: Optional[SubscriptionProtocol] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.GetDataLakeExceptionSubscriptionResponse = {
    import GetDataLakeExceptionSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.GetDataLakeExceptionSubscriptionResponse
      .builder()
      .optionallyWith(exceptionTimeToLive.map(value => value: java.lang.Long))(
        _.exceptionTimeToLive
      )
      .optionallyWith(
        notificationEndpoint.map(value =>
          SafeString.unwrap(value): java.lang.String
        )
      )(_.notificationEndpoint)
      .optionallyWith(
        subscriptionProtocol.map(value =>
          SubscriptionProtocol.unwrap(value): java.lang.String
        )
      )(_.subscriptionProtocol)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionResponse.ReadOnly =
    zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionResponse
      .wrap(buildAwsValue())
}
object GetDataLakeExceptionSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.GetDataLakeExceptionSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionResponse =
      zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionResponse(
        exceptionTimeToLive.map(value => value),
        notificationEndpoint.map(value => value),
        subscriptionProtocol.map(value => value)
      )
    def exceptionTimeToLive: Optional[Long]
    def notificationEndpoint: Optional[SafeString]
    def subscriptionProtocol: Optional[SubscriptionProtocol]
    def getExceptionTimeToLive: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("exceptionTimeToLive", exceptionTimeToLive)
    def getNotificationEndpoint: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("notificationEndpoint", notificationEndpoint)
    def getSubscriptionProtocol: ZIO[Any, AwsError, SubscriptionProtocol] =
      AwsError.unwrapOptionField("subscriptionProtocol", subscriptionProtocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.GetDataLakeExceptionSubscriptionResponse
  ) extends zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionResponse.ReadOnly {
    override val exceptionTimeToLive: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.exceptionTimeToLive())
      .map(value => value: Long)
    override val notificationEndpoint: Optional[SafeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationEndpoint())
        .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
    override val subscriptionProtocol: Optional[SubscriptionProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionProtocol())
        .map(value =>
          zio.aws.securitylake.model.primitives.SubscriptionProtocol(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.GetDataLakeExceptionSubscriptionResponse
  ): zio.aws.securitylake.model.GetDataLakeExceptionSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
