package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{NextToken, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDataLakeSourcesResponse(
    dataLakeArn: Optional[AmazonResourceName] = Optional.Absent,
    dataLakeSources: Optional[
      Iterable[zio.aws.securitylake.model.DataLakeSource]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesResponse = {
    import GetDataLakeSourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesResponse
      .builder()
      .optionallyWith(
        dataLakeArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.dataLakeArn)
      .optionallyWith(
        dataLakeSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataLakeSources)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.GetDataLakeSourcesResponse.ReadOnly =
    zio.aws.securitylake.model.GetDataLakeSourcesResponse.wrap(buildAwsValue())
}
object GetDataLakeSourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.GetDataLakeSourcesResponse =
      zio.aws.securitylake.model.GetDataLakeSourcesResponse(
        dataLakeArn.map(value => value),
        dataLakeSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dataLakeArn: Optional[AmazonResourceName]
    def dataLakeSources
        : Optional[List[zio.aws.securitylake.model.DataLakeSource.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDataLakeArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("dataLakeArn", dataLakeArn)
    def getDataLakeSources: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.DataLakeSource.ReadOnly
    ]] = AwsError.unwrapOptionField("dataLakeSources", dataLakeSources)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesResponse
  ) extends zio.aws.securitylake.model.GetDataLakeSourcesResponse.ReadOnly {
    override val dataLakeArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataLakeArn())
        .map(value =>
          zio.aws.securitylake.model.primitives.AmazonResourceName(value)
        )
    override val dataLakeSources
        : Optional[List[zio.aws.securitylake.model.DataLakeSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataLakeSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.DataLakeSource.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securitylake.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesResponse
  ): zio.aws.securitylake.model.GetDataLakeSourcesResponse.ReadOnly =
    new Wrapper(impl)
}
