package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  RoleArn,
  HttpsNotificationConfigurationEndpointString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HttpsNotificationConfiguration(
    authorizationApiKeyName: Optional[String] = Optional.Absent,
    authorizationApiKeyValue: Optional[String] = Optional.Absent,
    endpoint: HttpsNotificationConfigurationEndpointString,
    httpMethod: Optional[zio.aws.securitylake.model.HttpMethod] =
      Optional.Absent,
    targetRoleArn: RoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.HttpsNotificationConfiguration = {
    import HttpsNotificationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.HttpsNotificationConfiguration
      .builder()
      .optionallyWith(
        authorizationApiKeyName.map(value => value: java.lang.String)
      )(_.authorizationApiKeyName)
      .optionallyWith(
        authorizationApiKeyValue.map(value => value: java.lang.String)
      )(_.authorizationApiKeyValue)
      .endpoint(
        HttpsNotificationConfigurationEndpointString.unwrap(
          endpoint
        ): java.lang.String
      )
      .optionallyWith(httpMethod.map(value => value.unwrap))(_.httpMethod)
      .targetRoleArn(RoleArn.unwrap(targetRoleArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.HttpsNotificationConfiguration.ReadOnly =
    zio.aws.securitylake.model.HttpsNotificationConfiguration
      .wrap(buildAwsValue())
}
object HttpsNotificationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.HttpsNotificationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.HttpsNotificationConfiguration =
      zio.aws.securitylake.model.HttpsNotificationConfiguration(
        authorizationApiKeyName.map(value => value),
        authorizationApiKeyValue.map(value => value),
        endpoint,
        httpMethod.map(value => value),
        targetRoleArn
      )
    def authorizationApiKeyName: Optional[String]
    def authorizationApiKeyValue: Optional[String]
    def endpoint: HttpsNotificationConfigurationEndpointString
    def httpMethod: Optional[zio.aws.securitylake.model.HttpMethod]
    def targetRoleArn: RoleArn
    def getAuthorizationApiKeyName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("authorizationApiKeyName", authorizationApiKeyName)
    def getAuthorizationApiKeyValue: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("authorizationApiKeyValue", authorizationApiKeyValue)
    def getEndpoint
        : ZIO[Any, Nothing, HttpsNotificationConfigurationEndpointString] =
      ZIO.succeed(endpoint)
    def getHttpMethod
        : ZIO[Any, AwsError, zio.aws.securitylake.model.HttpMethod] =
      AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getTargetRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(targetRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.HttpsNotificationConfiguration
  ) extends zio.aws.securitylake.model.HttpsNotificationConfiguration.ReadOnly {
    override val authorizationApiKeyName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizationApiKeyName())
        .map(value => value: String)
    override val authorizationApiKeyValue: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizationApiKeyValue())
        .map(value => value: String)
    override val endpoint: HttpsNotificationConfigurationEndpointString =
      zio.aws.securitylake.model.primitives
        .HttpsNotificationConfigurationEndpointString(impl.endpoint())
    override val httpMethod: Optional[zio.aws.securitylake.model.HttpMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpMethod())
        .map(value => zio.aws.securitylake.model.HttpMethod.wrap(value))
    override val targetRoleArn: RoleArn =
      zio.aws.securitylake.model.primitives.RoleArn(impl.targetRoleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.HttpsNotificationConfiguration
  ): zio.aws.securitylake.model.HttpsNotificationConfiguration.ReadOnly =
    new Wrapper(impl)
}
