package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDataLakeExceptionsResponse(
    exceptions: Optional[
      Iterable[zio.aws.securitylake.model.DataLakeException]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.ListDataLakeExceptionsResponse = {
    import ListDataLakeExceptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.ListDataLakeExceptionsResponse
      .builder()
      .optionallyWith(
        exceptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exceptions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.ListDataLakeExceptionsResponse.ReadOnly =
    zio.aws.securitylake.model.ListDataLakeExceptionsResponse
      .wrap(buildAwsValue())
}
object ListDataLakeExceptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.ListDataLakeExceptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.ListDataLakeExceptionsResponse =
      zio.aws.securitylake.model.ListDataLakeExceptionsResponse(
        exceptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def exceptions
        : Optional[List[zio.aws.securitylake.model.DataLakeException.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getExceptions: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.DataLakeException.ReadOnly
    ]] = AwsError.unwrapOptionField("exceptions", exceptions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.ListDataLakeExceptionsResponse
  ) extends zio.aws.securitylake.model.ListDataLakeExceptionsResponse.ReadOnly {
    override val exceptions: Optional[
      List[zio.aws.securitylake.model.DataLakeException.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exceptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.DataLakeException.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securitylake.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.ListDataLakeExceptionsResponse
  ): zio.aws.securitylake.model.ListDataLakeExceptionsResponse.ReadOnly =
    new Wrapper(impl)
}
