package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.Region
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDataLakesRequest(
    regions: Optional[Iterable[Region]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.ListDataLakesRequest = {
    import ListDataLakesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.ListDataLakesRequest
      .builder()
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.ListDataLakesRequest.ReadOnly =
    zio.aws.securitylake.model.ListDataLakesRequest.wrap(buildAwsValue())
}
object ListDataLakesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.ListDataLakesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.ListDataLakesRequest =
      zio.aws.securitylake.model
        .ListDataLakesRequest(regions.map(value => value))
    def regions: Optional[List[Region]]
    def getRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.ListDataLakesRequest
  ) extends zio.aws.securitylake.model.ListDataLakesRequest.ReadOnly {
    override val regions: Optional[List[Region]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.primitives.Region(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.ListDataLakesRequest
  ): zio.aws.securitylake.model.ListDataLakesRequest.ReadOnly = new Wrapper(
    impl
  )
}
