package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDataLakesResponse(
    dataLakes: Optional[Iterable[zio.aws.securitylake.model.DataLakeResource]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.ListDataLakesResponse = {
    import ListDataLakesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.ListDataLakesResponse
      .builder()
      .optionallyWith(
        dataLakes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataLakes)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.ListDataLakesResponse.ReadOnly =
    zio.aws.securitylake.model.ListDataLakesResponse.wrap(buildAwsValue())
}
object ListDataLakesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.ListDataLakesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.ListDataLakesResponse =
      zio.aws.securitylake.model.ListDataLakesResponse(
        dataLakes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dataLakes
        : Optional[List[zio.aws.securitylake.model.DataLakeResource.ReadOnly]]
    def getDataLakes: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.DataLakeResource.ReadOnly
    ]] = AwsError.unwrapOptionField("dataLakes", dataLakes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.ListDataLakesResponse
  ) extends zio.aws.securitylake.model.ListDataLakesResponse.ReadOnly {
    override val dataLakes
        : Optional[List[zio.aws.securitylake.model.DataLakeResource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataLakes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.DataLakeResource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.ListDataLakesResponse
  ): zio.aws.securitylake.model.ListDataLakesResponse.ReadOnly = new Wrapper(
    impl
  )
}
