package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSubscribersResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    subscribers: Optional[
      Iterable[zio.aws.securitylake.model.SubscriberResource]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse = {
    import ListSubscribersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        subscribers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscribers)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly =
    zio.aws.securitylake.model.ListSubscribersResponse.wrap(buildAwsValue())
}
object ListSubscribersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.ListSubscribersResponse =
      zio.aws.securitylake.model.ListSubscribersResponse(
        nextToken.map(value => value),
        subscribers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def subscribers
        : Optional[List[zio.aws.securitylake.model.SubscriberResource.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSubscribers: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.SubscriberResource.ReadOnly
    ]] = AwsError.unwrapOptionField("subscribers", subscribers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse
  ) extends zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securitylake.model.primitives.NextToken(value))
    override val subscribers: Optional[
      List[zio.aws.securitylake.model.SubscriberResource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.subscribers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.SubscriberResource.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse
  ): zio.aws.securitylake.model.ListSubscribersResponse.ReadOnly = new Wrapper(
    impl
  )
}
