package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{Region, AwsAccountId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LogSource(
    account: Optional[AwsAccountId] = Optional.Absent,
    region: Optional[Region] = Optional.Absent,
    sources: Optional[Iterable[zio.aws.securitylake.model.LogSourceResource]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.LogSource = {
    import LogSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.LogSource
      .builder()
      .optionallyWith(
        account.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.account)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.LogSource.ReadOnly =
    zio.aws.securitylake.model.LogSource.wrap(buildAwsValue())
}
object LogSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.LogSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.LogSource =
      zio.aws.securitylake.model.LogSource(
        account.map(value => value),
        region.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def account: Optional[AwsAccountId]
    def region: Optional[Region]
    def sources
        : Optional[List[zio.aws.securitylake.model.LogSourceResource.ReadOnly]]
    def getAccount: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("account", account)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.LogSourceResource.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.LogSource
  ) extends zio.aws.securitylake.model.LogSource.ReadOnly {
    override val account: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.account())
      .map(value => zio.aws.securitylake.model.primitives.AwsAccountId(value))
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.securitylake.model.primitives.Region(value))
    override val sources: Optional[
      List[zio.aws.securitylake.model.LogSourceResource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.LogSourceResource.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.LogSource
  ): zio.aws.securitylake.model.LogSource.ReadOnly = new Wrapper(impl)
}
