package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LogSourceResource(
    awsLogSource: Optional[zio.aws.securitylake.model.AwsLogSourceResource] =
      Optional.Absent,
    customLogSource: Optional[
      zio.aws.securitylake.model.CustomLogSourceResource
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.LogSourceResource = {
    import LogSourceResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.LogSourceResource
      .builder()
      .optionallyWith(awsLogSource.map(value => value.buildAwsValue()))(
        _.awsLogSource
      )
      .optionallyWith(customLogSource.map(value => value.buildAwsValue()))(
        _.customLogSource
      )
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.LogSourceResource.ReadOnly =
    zio.aws.securitylake.model.LogSourceResource.wrap(buildAwsValue())
}
object LogSourceResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.LogSourceResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.LogSourceResource =
      zio.aws.securitylake.model.LogSourceResource(
        awsLogSource.map(value => value.asEditable),
        customLogSource.map(value => value.asEditable)
      )
    def awsLogSource
        : Optional[zio.aws.securitylake.model.AwsLogSourceResource.ReadOnly]
    def customLogSource
        : Optional[zio.aws.securitylake.model.CustomLogSourceResource.ReadOnly]
    def getAwsLogSource: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.AwsLogSourceResource.ReadOnly
    ] = AwsError.unwrapOptionField("awsLogSource", awsLogSource)
    def getCustomLogSource: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.CustomLogSourceResource.ReadOnly
    ] = AwsError.unwrapOptionField("customLogSource", customLogSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.LogSourceResource
  ) extends zio.aws.securitylake.model.LogSourceResource.ReadOnly {
    override val awsLogSource
        : Optional[zio.aws.securitylake.model.AwsLogSourceResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsLogSource())
        .map(value =>
          zio.aws.securitylake.model.AwsLogSourceResource.wrap(value)
        )
    override val customLogSource: Optional[
      zio.aws.securitylake.model.CustomLogSourceResource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customLogSource())
      .map(value =>
        zio.aws.securitylake.model.CustomLogSourceResource.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.LogSourceResource
  ): zio.aws.securitylake.model.LogSourceResource.ReadOnly = new Wrapper(impl)
}
