package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegisterDataLakeDelegatedAdministratorRequest(
    accountId: SafeString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest = {
    import RegisterDataLakeDelegatedAdministratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest
      .builder()
      .accountId(SafeString.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest.ReadOnly =
    zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest
      .wrap(buildAwsValue())
}
object RegisterDataLakeDelegatedAdministratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest =
      zio.aws.securitylake.model
        .RegisterDataLakeDelegatedAdministratorRequest(accountId)
    def accountId: SafeString
    def getAccountId: ZIO[Any, Nothing, SafeString] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest
  ) extends zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest.ReadOnly {
    override val accountId: SafeString =
      zio.aws.securitylake.model.primitives.SafeString(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest
  ): zio.aws.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest.ReadOnly =
    new Wrapper(impl)
}
