package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  SubscriptionProtocol,
  SafeString,
  UpdateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDataLakeExceptionSubscriptionRequest(
    exceptionTimeToLive: Optional[
      UpdateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
    ] = Optional.Absent,
    notificationEndpoint: SafeString,
    subscriptionProtocol: SubscriptionProtocol
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest = {
    import UpdateDataLakeExceptionSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest
      .builder()
      .optionallyWith(
        exceptionTimeToLive.map(value =>
          UpdateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
            .unwrap(value): java.lang.Long
        )
      )(_.exceptionTimeToLive)
      .notificationEndpoint(
        SafeString.unwrap(notificationEndpoint): java.lang.String
      )
      .subscriptionProtocol(
        SubscriptionProtocol.unwrap(subscriptionProtocol): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest.ReadOnly =
    zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest
      .wrap(buildAwsValue())
}
object UpdateDataLakeExceptionSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest =
      zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest(
        exceptionTimeToLive.map(value => value),
        notificationEndpoint,
        subscriptionProtocol
      )
    def exceptionTimeToLive: Optional[
      UpdateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
    ]
    def notificationEndpoint: SafeString
    def subscriptionProtocol: SubscriptionProtocol
    def getExceptionTimeToLive: ZIO[
      Any,
      AwsError,
      UpdateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
    ] = AwsError.unwrapOptionField("exceptionTimeToLive", exceptionTimeToLive)
    def getNotificationEndpoint: ZIO[Any, Nothing, SafeString] =
      ZIO.succeed(notificationEndpoint)
    def getSubscriptionProtocol: ZIO[Any, Nothing, SubscriptionProtocol] =
      ZIO.succeed(subscriptionProtocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest
  ) extends zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest.ReadOnly {
    override val exceptionTimeToLive: Optional[
      UpdateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exceptionTimeToLive())
      .map(value =>
        zio.aws.securitylake.model.primitives
          .UpdateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong(
            value
          )
      )
    override val notificationEndpoint: SafeString =
      zio.aws.securitylake.model.primitives
        .SafeString(impl.notificationEndpoint())
    override val subscriptionProtocol: SubscriptionProtocol =
      zio.aws.securitylake.model.primitives
        .SubscriptionProtocol(impl.subscriptionProtocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest
  ): zio.aws.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
