package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateDataLakeRequest(
    configurations: Iterable[zio.aws.securitylake.model.DataLakeConfiguration]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.UpdateDataLakeRequest = {
    import UpdateDataLakeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.UpdateDataLakeRequest
      .builder()
      .configurations(configurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.UpdateDataLakeRequest.ReadOnly =
    zio.aws.securitylake.model.UpdateDataLakeRequest.wrap(buildAwsValue())
}
object UpdateDataLakeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.UpdateDataLakeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.UpdateDataLakeRequest =
      zio.aws.securitylake.model.UpdateDataLakeRequest(configurations.map {
        item =>
          item.asEditable
      })
    def configurations
        : List[zio.aws.securitylake.model.DataLakeConfiguration.ReadOnly]
    def getConfigurations: ZIO[Any, Nothing, List[
      zio.aws.securitylake.model.DataLakeConfiguration.ReadOnly
    ]] = ZIO.succeed(configurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateDataLakeRequest
  ) extends zio.aws.securitylake.model.UpdateDataLakeRequest.ReadOnly {
    override val configurations
        : List[zio.aws.securitylake.model.DataLakeConfiguration.ReadOnly] = impl
      .configurations()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.DataLakeConfiguration.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateDataLakeRequest
  ): zio.aws.securitylake.model.UpdateDataLakeRequest.ReadOnly = new Wrapper(
    impl
  )
}
