package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.UUID
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateSubscriberNotificationRequest(
    configuration: zio.aws.securitylake.model.NotificationConfiguration,
    subscriberId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.UpdateSubscriberNotificationRequest = {
    import UpdateSubscriberNotificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.UpdateSubscriberNotificationRequest
      .builder()
      .configuration(configuration.buildAwsValue())
      .subscriberId(UUID.unwrap(subscriberId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.UpdateSubscriberNotificationRequest.ReadOnly =
    zio.aws.securitylake.model.UpdateSubscriberNotificationRequest
      .wrap(buildAwsValue())
}
object UpdateSubscriberNotificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.UpdateSubscriberNotificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.UpdateSubscriberNotificationRequest =
      zio.aws.securitylake.model.UpdateSubscriberNotificationRequest(
        configuration.asEditable,
        subscriberId
      )
    def configuration
        : zio.aws.securitylake.model.NotificationConfiguration.ReadOnly
    def subscriberId: UUID
    def getConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.securitylake.model.NotificationConfiguration.ReadOnly
    ] = ZIO.succeed(configuration)
    def getSubscriberId: ZIO[Any, Nothing, UUID] = ZIO.succeed(subscriberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateSubscriberNotificationRequest
  ) extends zio.aws.securitylake.model.UpdateSubscriberNotificationRequest.ReadOnly {
    override val configuration
        : zio.aws.securitylake.model.NotificationConfiguration.ReadOnly =
      zio.aws.securitylake.model.NotificationConfiguration
        .wrap(impl.configuration())
    override val subscriberId: UUID =
      zio.aws.securitylake.model.primitives.UUID(impl.subscriberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateSubscriberNotificationRequest
  ): zio.aws.securitylake.model.UpdateSubscriberNotificationRequest.ReadOnly =
    new Wrapper(impl)
}
