package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.SafeString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSubscriberNotificationResponse(
    subscriberEndpoint: Optional[SafeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.UpdateSubscriberNotificationResponse = {
    import UpdateSubscriberNotificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.UpdateSubscriberNotificationResponse
      .builder()
      .optionallyWith(
        subscriberEndpoint.map(value =>
          SafeString.unwrap(value): java.lang.String
        )
      )(_.subscriberEndpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.UpdateSubscriberNotificationResponse.ReadOnly =
    zio.aws.securitylake.model.UpdateSubscriberNotificationResponse
      .wrap(buildAwsValue())
}
object UpdateSubscriberNotificationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.UpdateSubscriberNotificationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.UpdateSubscriberNotificationResponse =
      zio.aws.securitylake.model.UpdateSubscriberNotificationResponse(
        subscriberEndpoint.map(value => value)
      )
    def subscriberEndpoint: Optional[SafeString]
    def getSubscriberEndpoint: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("subscriberEndpoint", subscriberEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateSubscriberNotificationResponse
  ) extends zio.aws.securitylake.model.UpdateSubscriberNotificationResponse.ReadOnly {
    override val subscriberEndpoint: Optional[SafeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriberEndpoint())
        .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateSubscriberNotificationResponse
  ): zio.aws.securitylake.model.UpdateSubscriberNotificationResponse.ReadOnly =
    new Wrapper(impl)
}
