package zio.aws.securitylake
import zio.aws.securitylake.model.primitives.{
  TagKey,
  Region,
  OcsfEventClass,
  AwsAccountId
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.securitylake.model.primitives.DataLakeStorageClass.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.securitylake.model.primitives.AmazonResourceName.Type
    object AwsAccountId extends Subtype[String]
    type AwsAccountId = zio.aws.securitylake.model.primitives.AwsAccountId.Type
    object AwsLogSourceVersion extends Subtype[String]
    type AwsLogSourceVersion =
      zio.aws.securitylake.model.primitives.AwsLogSourceVersion.Type
    object AwsPrincipal extends Subtype[String]
    type AwsPrincipal = zio.aws.securitylake.model.primitives.AwsPrincipal.Type
    object CreateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
        extends Subtype[Long]
    type CreateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong =
      zio.aws.securitylake.model.primitives.CreateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong.Type
    object CreateSubscriberRequestSubscriberNameString extends Subtype[String]
    type CreateSubscriberRequestSubscriberNameString =
      zio.aws.securitylake.model.primitives.CreateSubscriberRequestSubscriberNameString.Type
    object CustomLogSourceName extends Subtype[String]
    type CustomLogSourceName =
      zio.aws.securitylake.model.primitives.CustomLogSourceName.Type
    object CustomLogSourceVersion extends Subtype[String]
    type CustomLogSourceVersion =
      zio.aws.securitylake.model.primitives.CustomLogSourceVersion.Type
    object DataLakeLifecycleExpirationDaysInteger extends Subtype[Int]
    type DataLakeLifecycleExpirationDaysInteger =
      zio.aws.securitylake.model.primitives.DataLakeLifecycleExpirationDaysInteger.Type
    object DataLakeLifecycleTransitionDaysInteger extends Subtype[Int]
    type DataLakeLifecycleTransitionDaysInteger =
      zio.aws.securitylake.model.primitives.DataLakeLifecycleTransitionDaysInteger.Type
    object DataLakeStorageClass extends Subtype[String]
    type DataLakeStorageClass =
      zio.aws.securitylake.model.primitives.DataLakeStorageClass.Type
    object DescriptionString extends Subtype[String]
    type DescriptionString =
      zio.aws.securitylake.model.primitives.DescriptionString.Type
    object ExternalId extends Subtype[String]
    type ExternalId = zio.aws.securitylake.model.primitives.ExternalId.Type
    object HttpsNotificationConfigurationEndpointString extends Subtype[String]
    type HttpsNotificationConfigurationEndpointString =
      zio.aws.securitylake.model.primitives.HttpsNotificationConfigurationEndpointString.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.securitylake.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.securitylake.model.primitives.NextToken.Type
    object OcsfEventClass extends Subtype[String]
    type OcsfEventClass =
      zio.aws.securitylake.model.primitives.OcsfEventClass.Type
    object Region extends Subtype[String]
    type Region = zio.aws.securitylake.model.primitives.Region.Type
    object ResourceShareArn extends Subtype[String]
    type ResourceShareArn =
      zio.aws.securitylake.model.primitives.ResourceShareArn.Type
    object ResourceShareName extends Subtype[String]
    type ResourceShareName =
      zio.aws.securitylake.model.primitives.ResourceShareName.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.securitylake.model.primitives.RoleArn.Type
    object S3BucketArn extends Subtype[String]
    type S3BucketArn = zio.aws.securitylake.model.primitives.S3BucketArn.Type
    object S3URI extends Subtype[String]
    type S3URI = zio.aws.securitylake.model.primitives.S3URI.Type
    object SafeString extends Subtype[String]
    type SafeString = zio.aws.securitylake.model.primitives.SafeString.Type
    object SubscriptionProtocol extends Subtype[String]
    type SubscriptionProtocol =
      zio.aws.securitylake.model.primitives.SubscriptionProtocol.Type
    object SyntheticTimestamp_date_time extends Subtype[Instant]
    type SyntheticTimestamp_date_time =
      zio.aws.securitylake.model.primitives.SyntheticTimestamp_date_time.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.securitylake.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.securitylake.model.primitives.TagValue.Type
    object UUID extends Subtype[String]
    type UUID = zio.aws.securitylake.model.primitives.UUID.Type
    object UpdateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
        extends Subtype[Long]
    type UpdateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong =
      zio.aws.securitylake.model.primitives.UpdateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong.Type
    object UpdateSubscriberRequestSubscriberNameString extends Subtype[String]
    type UpdateSubscriberRequestSubscriberNameString =
      zio.aws.securitylake.model.primitives.UpdateSubscriberRequestSubscriberNameString.Type
  }
  type AccessTypeList = List[zio.aws.securitylake.model.AccessType]
  type AccountList = List[AwsAccountId]
  type AwsLogSourceConfigurationList =
    List[zio.aws.securitylake.model.AwsLogSourceConfiguration]
  type AwsLogSourceResourceList =
    List[zio.aws.securitylake.model.AwsLogSourceResource]
  type DataLakeAutoEnableNewAccountConfigurationList =
    List[zio.aws.securitylake.model.DataLakeAutoEnableNewAccountConfiguration]
  type DataLakeConfigurationList =
    List[zio.aws.securitylake.model.DataLakeConfiguration]
  type DataLakeExceptionList =
    List[zio.aws.securitylake.model.DataLakeException]
  type DataLakeLifecycleTransitionList =
    List[zio.aws.securitylake.model.DataLakeLifecycleTransition]
  type DataLakeResourceList = List[zio.aws.securitylake.model.DataLakeResource]
  type DataLakeSourceList = List[zio.aws.securitylake.model.DataLakeSource]
  type DataLakeSourceStatusList =
    List[zio.aws.securitylake.model.DataLakeSourceStatus]
  type LogSourceList = List[zio.aws.securitylake.model.LogSource]
  type LogSourceResourceList =
    List[zio.aws.securitylake.model.LogSourceResource]
  type OcsfEventClassList = List[OcsfEventClass]
  type RegionList = List[Region]
  type SubscriberResourceList =
    List[zio.aws.securitylake.model.SubscriberResource]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.securitylake.model.Tag]
}
