package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{AwsPrincipal, ExternalId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AwsIdentity(externalId: ExternalId, principal: AwsPrincipal) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.AwsIdentity = {
    import AwsIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.AwsIdentity
      .builder()
      .externalId(ExternalId.unwrap(externalId): java.lang.String)
      .principal(AwsPrincipal.unwrap(principal): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.AwsIdentity.ReadOnly =
    zio.aws.securitylake.model.AwsIdentity.wrap(buildAwsValue())
}
object AwsIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.AwsIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.AwsIdentity =
      zio.aws.securitylake.model.AwsIdentity(externalId, principal)
    def externalId: ExternalId
    def principal: AwsPrincipal
    def getExternalId: ZIO[Any, Nothing, ExternalId] = ZIO.succeed(externalId)
    def getPrincipal: ZIO[Any, Nothing, AwsPrincipal] = ZIO.succeed(principal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.AwsIdentity
  ) extends zio.aws.securitylake.model.AwsIdentity.ReadOnly {
    override val externalId: ExternalId =
      zio.aws.securitylake.model.primitives.ExternalId(impl.externalId())
    override val principal: AwsPrincipal =
      zio.aws.securitylake.model.primitives.AwsPrincipal(impl.principal())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.AwsIdentity
  ): zio.aws.securitylake.model.AwsIdentity.ReadOnly = new Wrapper(impl)
}
