package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  AwsLogSourceVersion,
  Region,
  AwsAccountId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AwsLogSourceConfiguration(
    accounts: Optional[Iterable[AwsAccountId]] = Optional.Absent,
    regions: Iterable[Region],
    sourceName: zio.aws.securitylake.model.AwsLogSourceName,
    sourceVersion: Optional[AwsLogSourceVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.AwsLogSourceConfiguration = {
    import AwsLogSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.AwsLogSourceConfiguration
      .builder()
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            AwsAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .regions(regions.map { item =>
        Region.unwrap(item): java.lang.String
      }.asJavaCollection)
      .sourceName(sourceName.unwrap)
      .optionallyWith(
        sourceVersion.map(value =>
          AwsLogSourceVersion.unwrap(value): java.lang.String
        )
      )(_.sourceVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.AwsLogSourceConfiguration.ReadOnly =
    zio.aws.securitylake.model.AwsLogSourceConfiguration.wrap(buildAwsValue())
}
object AwsLogSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.AwsLogSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.AwsLogSourceConfiguration =
      zio.aws.securitylake.model.AwsLogSourceConfiguration(
        accounts.map(value => value),
        regions,
        sourceName,
        sourceVersion.map(value => value)
      )
    def accounts: Optional[List[AwsAccountId]]
    def regions: List[Region]
    def sourceName: zio.aws.securitylake.model.AwsLogSourceName
    def sourceVersion: Optional[AwsLogSourceVersion]
    def getAccounts: ZIO[Any, AwsError, List[AwsAccountId]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getRegions: ZIO[Any, Nothing, List[Region]] = ZIO.succeed(regions)
    def getSourceName
        : ZIO[Any, Nothing, zio.aws.securitylake.model.AwsLogSourceName] =
      ZIO.succeed(sourceName)
    def getSourceVersion: ZIO[Any, AwsError, AwsLogSourceVersion] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.AwsLogSourceConfiguration
  ) extends zio.aws.securitylake.model.AwsLogSourceConfiguration.ReadOnly {
    override val accounts: Optional[List[AwsAccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.primitives.AwsAccountId(item)
        }.toList
      )
    override val regions: List[Region] = impl
      .regions()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.primitives.Region(item)
      }
      .toList
    override val sourceName: zio.aws.securitylake.model.AwsLogSourceName =
      zio.aws.securitylake.model.AwsLogSourceName.wrap(impl.sourceName())
    override val sourceVersion: Optional[AwsLogSourceVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceVersion())
        .map(value =>
          zio.aws.securitylake.model.primitives.AwsLogSourceVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.AwsLogSourceConfiguration
  ): zio.aws.securitylake.model.AwsLogSourceConfiguration.ReadOnly =
    new Wrapper(impl)
}
