package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.AwsLogSourceVersion
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AwsLogSourceResource(
    sourceName: Optional[zio.aws.securitylake.model.AwsLogSourceName] =
      Optional.Absent,
    sourceVersion: Optional[AwsLogSourceVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.AwsLogSourceResource = {
    import AwsLogSourceResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.AwsLogSourceResource
      .builder()
      .optionallyWith(sourceName.map(value => value.unwrap))(_.sourceName)
      .optionallyWith(
        sourceVersion.map(value =>
          AwsLogSourceVersion.unwrap(value): java.lang.String
        )
      )(_.sourceVersion)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.AwsLogSourceResource.ReadOnly =
    zio.aws.securitylake.model.AwsLogSourceResource.wrap(buildAwsValue())
}
object AwsLogSourceResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.AwsLogSourceResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.AwsLogSourceResource =
      zio.aws.securitylake.model.AwsLogSourceResource(
        sourceName.map(value => value),
        sourceVersion.map(value => value)
      )
    def sourceName: Optional[zio.aws.securitylake.model.AwsLogSourceName]
    def sourceVersion: Optional[AwsLogSourceVersion]
    def getSourceName
        : ZIO[Any, AwsError, zio.aws.securitylake.model.AwsLogSourceName] =
      AwsError.unwrapOptionField("sourceName", sourceName)
    def getSourceVersion: ZIO[Any, AwsError, AwsLogSourceVersion] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.AwsLogSourceResource
  ) extends zio.aws.securitylake.model.AwsLogSourceResource.ReadOnly {
    override val sourceName
        : Optional[zio.aws.securitylake.model.AwsLogSourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceName())
        .map(value => zio.aws.securitylake.model.AwsLogSourceName.wrap(value))
    override val sourceVersion: Optional[AwsLogSourceVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceVersion())
        .map(value =>
          zio.aws.securitylake.model.primitives.AwsLogSourceVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.AwsLogSourceResource
  ): zio.aws.securitylake.model.AwsLogSourceResource.ReadOnly = new Wrapper(
    impl
  )
}
