package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.AwsAccountId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAwsLogSourceResponse(
    failed: Optional[Iterable[AwsAccountId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse = {
    import CreateAwsLogSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse
      .builder()
      .optionallyWith(
        failed.map(value =>
          value.map { item =>
            AwsAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.failed)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly =
    zio.aws.securitylake.model.CreateAwsLogSourceResponse.wrap(buildAwsValue())
}
object CreateAwsLogSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateAwsLogSourceResponse =
      zio.aws.securitylake.model
        .CreateAwsLogSourceResponse(failed.map(value => value))
    def failed: Optional[List[AwsAccountId]]
    def getFailed: ZIO[Any, AwsError, List[AwsAccountId]] =
      AwsError.unwrapOptionField("failed", failed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse
  ) extends zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly {
    override val failed: Optional[List[AwsAccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.failed())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.primitives.AwsAccountId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse
  ): zio.aws.securitylake.model.CreateAwsLogSourceResponse.ReadOnly =
    new Wrapper(impl)
}
