package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  CustomLogSourceVersion,
  CustomLogSourceName,
  OcsfEventClass
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCustomLogSourceRequest(
    configuration: Optional[
      zio.aws.securitylake.model.CustomLogSourceConfiguration
    ] = Optional.Absent,
    eventClasses: Optional[Iterable[OcsfEventClass]] = Optional.Absent,
    sourceName: CustomLogSourceName,
    sourceVersion: Optional[CustomLogSourceVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest = {
    import CreateCustomLogSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        eventClasses.map(value =>
          value.map { item =>
            OcsfEventClass.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.eventClasses)
      .sourceName(CustomLogSourceName.unwrap(sourceName): java.lang.String)
      .optionallyWith(
        sourceVersion.map(value =>
          CustomLogSourceVersion.unwrap(value): java.lang.String
        )
      )(_.sourceVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CreateCustomLogSourceRequest.ReadOnly =
    zio.aws.securitylake.model.CreateCustomLogSourceRequest
      .wrap(buildAwsValue())
}
object CreateCustomLogSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateCustomLogSourceRequest =
      zio.aws.securitylake.model.CreateCustomLogSourceRequest(
        configuration.map(value => value.asEditable),
        eventClasses.map(value => value),
        sourceName,
        sourceVersion.map(value => value)
      )
    def configuration: Optional[
      zio.aws.securitylake.model.CustomLogSourceConfiguration.ReadOnly
    ]
    def eventClasses: Optional[List[OcsfEventClass]]
    def sourceName: CustomLogSourceName
    def sourceVersion: Optional[CustomLogSourceVersion]
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.CustomLogSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getEventClasses: ZIO[Any, AwsError, List[OcsfEventClass]] =
      AwsError.unwrapOptionField("eventClasses", eventClasses)
    def getSourceName: ZIO[Any, Nothing, CustomLogSourceName] =
      ZIO.succeed(sourceName)
    def getSourceVersion: ZIO[Any, AwsError, CustomLogSourceVersion] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest
  ) extends zio.aws.securitylake.model.CreateCustomLogSourceRequest.ReadOnly {
    override val configuration: Optional[
      zio.aws.securitylake.model.CustomLogSourceConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value =>
        zio.aws.securitylake.model.CustomLogSourceConfiguration.wrap(value)
      )
    override val eventClasses: Optional[List[OcsfEventClass]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventClasses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.primitives.OcsfEventClass(item)
          }.toList
        )
    override val sourceName: CustomLogSourceName =
      zio.aws.securitylake.model.primitives
        .CustomLogSourceName(impl.sourceName())
    override val sourceVersion: Optional[CustomLogSourceVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceVersion())
        .map(value =>
          zio.aws.securitylake.model.primitives.CustomLogSourceVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest
  ): zio.aws.securitylake.model.CreateCustomLogSourceRequest.ReadOnly =
    new Wrapper(impl)
}
