package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  SubscriptionProtocol,
  SafeString,
  CreateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDataLakeExceptionSubscriptionRequest(
    exceptionTimeToLive: Optional[
      CreateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
    ] = Optional.Absent,
    notificationEndpoint: SafeString,
    subscriptionProtocol: SubscriptionProtocol
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateDataLakeExceptionSubscriptionRequest = {
    import CreateDataLakeExceptionSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateDataLakeExceptionSubscriptionRequest
      .builder()
      .optionallyWith(
        exceptionTimeToLive.map(value =>
          CreateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
            .unwrap(value): java.lang.Long
        )
      )(_.exceptionTimeToLive)
      .notificationEndpoint(
        SafeString.unwrap(notificationEndpoint): java.lang.String
      )
      .subscriptionProtocol(
        SubscriptionProtocol.unwrap(subscriptionProtocol): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionRequest.ReadOnly =
    zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionRequest
      .wrap(buildAwsValue())
}
object CreateDataLakeExceptionSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateDataLakeExceptionSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionRequest =
      zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionRequest(
        exceptionTimeToLive.map(value => value),
        notificationEndpoint,
        subscriptionProtocol
      )
    def exceptionTimeToLive: Optional[
      CreateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
    ]
    def notificationEndpoint: SafeString
    def subscriptionProtocol: SubscriptionProtocol
    def getExceptionTimeToLive: ZIO[
      Any,
      AwsError,
      CreateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
    ] = AwsError.unwrapOptionField("exceptionTimeToLive", exceptionTimeToLive)
    def getNotificationEndpoint: ZIO[Any, Nothing, SafeString] =
      ZIO.succeed(notificationEndpoint)
    def getSubscriptionProtocol: ZIO[Any, Nothing, SubscriptionProtocol] =
      ZIO.succeed(subscriptionProtocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateDataLakeExceptionSubscriptionRequest
  ) extends zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionRequest.ReadOnly {
    override val exceptionTimeToLive: Optional[
      CreateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exceptionTimeToLive())
      .map(value =>
        zio.aws.securitylake.model.primitives
          .CreateDataLakeExceptionSubscriptionRequestExceptionTimeToLiveLong(
            value
          )
      )
    override val notificationEndpoint: SafeString =
      zio.aws.securitylake.model.primitives
        .SafeString(impl.notificationEndpoint())
    override val subscriptionProtocol: SubscriptionProtocol =
      zio.aws.securitylake.model.primitives
        .SubscriptionProtocol(impl.subscriptionProtocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateDataLakeExceptionSubscriptionRequest
  ): zio.aws.securitylake.model.CreateDataLakeExceptionSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
