package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.RoleArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateDataLakeRequest(
    configurations: Iterable[zio.aws.securitylake.model.DataLakeConfiguration],
    metaStoreManagerRoleArn: RoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CreateDataLakeRequest = {
    import CreateDataLakeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CreateDataLakeRequest
      .builder()
      .configurations(configurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .metaStoreManagerRoleArn(
        RoleArn.unwrap(metaStoreManagerRoleArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.CreateDataLakeRequest.ReadOnly =
    zio.aws.securitylake.model.CreateDataLakeRequest.wrap(buildAwsValue())
}
object CreateDataLakeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CreateDataLakeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CreateDataLakeRequest =
      zio.aws.securitylake.model.CreateDataLakeRequest(
        configurations.map { item =>
          item.asEditable
        },
        metaStoreManagerRoleArn
      )
    def configurations
        : List[zio.aws.securitylake.model.DataLakeConfiguration.ReadOnly]
    def metaStoreManagerRoleArn: RoleArn
    def getConfigurations: ZIO[Any, Nothing, List[
      zio.aws.securitylake.model.DataLakeConfiguration.ReadOnly
    ]] = ZIO.succeed(configurations)
    def getMetaStoreManagerRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(metaStoreManagerRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CreateDataLakeRequest
  ) extends zio.aws.securitylake.model.CreateDataLakeRequest.ReadOnly {
    override val configurations
        : List[zio.aws.securitylake.model.DataLakeConfiguration.ReadOnly] = impl
      .configurations()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.DataLakeConfiguration.wrap(item)
      }
      .toList
    override val metaStoreManagerRoleArn: RoleArn =
      zio.aws.securitylake.model.primitives
        .RoleArn(impl.metaStoreManagerRoleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CreateDataLakeRequest
  ): zio.aws.securitylake.model.CreateDataLakeRequest.ReadOnly = new Wrapper(
    impl
  )
}
